# PSX_PGSQL
# ---------
AC_DEFUN([PSX_PGSQL], [
 AC_ARG_ENABLE(pgsql, AC_HELP_STRING([--disable-pgsql], [don't try to find Postgresql]),, enable_pkg=yes)

 AC_ARG_WITH(pgsql-prefix, AC_HELP_STRING([--with-pgsql-prefix=DIR], [search Postgresql header files in DIR/include, libraries in DIR/lib]),
             pkg_prefix=$withval, pkg_prefix="")
 if test "x$pkg_prefix" != x ; then
  LDFLAGS="-L$pkg_prefix/lib $LDFLAGS"
  CPPFLAGS="-I$pkg_prefix/include $CPPFLAGS"
 fi

 AC_ARG_WITH(pgsql-include, AC_HELP_STRING([--with-pgsql-include=DIR], [search Postgresql header files in DIR]),
             pkg_include=$withval, pkg_include="")
 if test "x$pkg_include" != x ; then
  CPPFLAGS="-I$pkg_include $CPPFLAGS"
 fi

 AC_ARG_WITH(pgsql-lib, AC_HELP_STRING([--with-pgsql-lib=DIR], [search Postgresql libraries in DIR]),
             pkg_lib=$withval, pkg_lib="")
 if test "x$pkg_lib" != x ; then
  LDFLAGS="-L$pkg_lib $LDFLAGS"
 fi

 AH_TEMPLATE(HAVE_PGSQL, [Define to 1 if Postgresql is available.])

 if test "x$enable_pkg" = "xyes" ; then

  # search in typical places for Postgresql header files:
  pgsql_include_dirs="/usr/local/pgsql/include \
                      /usr/include/postgresql \
                      /usr/include/pgsql"

  for dir in $pgsql_include_dirs ; do
   AC_MSG_CHECKING([whether directory $dir exists])
   if test -d $dir ; then
    CPPFLAGS="-I$dir $CPPFLAGS"
    AC_MSG_RESULT([yes])
   else
    AC_MSG_RESULT([no])
   fi
  done

  # search in typical places for Postgresql library:
  pgsql_lib_dirs="/usr/local/pgsql/lib \
                  /usr/lib/pgsql"

  for dir in $pgsql_lib_dirs ; do
   AC_MSG_CHECKING([whether directory $dir exists])
   if test -d $dir ; then
    LDFLAGS="-L$dir $LDFLAGS"
    AC_MSG_RESULT([yes])
   else
    AC_MSG_RESULT([no])
   fi
  done

  AC_CHECK_HEADER(libpq-fe.h, [
   AC_CHECK_LIB(pq, PQconnectdb, AC_DEFINE(HAVE_PGSQL) LIBS="-lpq $LIBS")
  ])
 fi
])

# PSX_PATH(PACKAGE, HEADER, LIBRARY, SYMBOL)
# ------------------------------------------
AC_DEFUN([PSX_PATH], [
 AC_ARG_ENABLE($1, AC_HELP_STRING([--disable-$1], [don't try to find $1]),, enable_pkg=yes)

 AC_ARG_WITH($1-prefix, AC_HELP_STRING([--with-$1-prefix=DIR], [search $1 header files in DIR/include, libraries in DIR/lib]),
             pkg_prefix=$withval, pkg_prefix="")
 if test "x$pkg_prefix" != x ; then
  LDFLAGS="-L$pkg_prefix/lib $LDFLAGS"
  CPPFLAGS="-I$pkg_prefix/include $CPPFLAGS"
 fi

 AC_ARG_WITH($1-include, AC_HELP_STRING([--with-$1-include=DIR], [search $1 header files in DIR]),
             pkg_include=$withval, pkg_include="")
 if test "x$pkg_include" != x ; then
  CPPFLAGS="-I$pkg_include $CPPFLAGS"
 fi

 AC_ARG_WITH($1-lib, AC_HELP_STRING([--with-$1-lib=DIR], [search $1 libraries in DIR]),
             pkg_lib=$withval, pkg_lib="")
 if test "x$pkg_lib" != x ; then
  LDFLAGS="-L$pkg_lib $LDFLAGS"
 fi

 AH_TEMPLATE(AS_TR_CPP(HAVE_[$1]), [Define to 1 if package $1 is available.])

 if test "x$enable_pkg" = "xyes" ; then
  AC_CHECK_HEADER($2, [
   AC_CHECK_LIB($3, $4, AC_DEFINE(AS_TR_CPP(HAVE_[$1])) LIBS="-l$3 $LIBS")
  ])
 fi
])

# PSX_CHK_ODBC
# ------------
AC_DEFUN([PSX_CHK_ODBC], [
 AC_ARG_ENABLE(odbc, AC_HELP_STRING([--disable-odbc], [don't try to find ODBC]),, enable_odbc=yes)

 AC_ARG_WITH(odbc-prefix, AC_HELP_STRING([--with-odbc-prefix=DIR], [search ODBC header files in DIR/include, libraries in DIR/lib]),
             odbc_prefix=$withval, odbc_prefix="")
 if test "x$odbc_prefix" != x ; then
  LDFLAGS="-L$odbc_prefix/lib $LDFLAGS"
  CPPFLAGS="-I$odbc_prefix/include $CPPFLAGS"
 fi

 AC_ARG_WITH(odbc-include, AC_HELP_STRING([--with-odbc-include=DIR], [search ODBC header files in DIR]),
             odbc_include=$withval, odbc_include="")
 if test "x$odbc_include" != x ; then
  CPPFLAGS="-I$odbc_include $CPPFLAGS"
 fi

 AC_ARG_WITH(odbc-lib, AC_HELP_STRING([--with-odbc-lib=DIR], [search ODBC libraries in DIR]),
             odbc_lib=$withval, odbc_lib="")
 if test "x$odbc_lib" != x ; then
  LDFLAGS="-L$odbc_lib $LDFLAGS"
 fi

 AH_TEMPLATE(HAVE_ODBC, [Define to 1 if ODBC is available.])

 if test "x$enable_odbc" = "xyes" ; then
  AC_CHECK_HEADER(sql.h, [
   AC_CHECK_HEADER(sqlext.h, [
    AC_CHECK_HEADER(odbcinst.h, [
     AC_CHECK_LIB(odbc, SQLConnect, [
      AC_CHECK_LIB(odbcinst, main, AC_DEFINE(HAVE_ODBC) LIBS="-lodbc -lodbcinst $LIBS")
     ])
    ])
   ])
  ])
 fi
])



