////////////////////////////////////////////////////////////////////////////////
// PSX Specification - KNAH    as defined 2005-03-18                          //
////////////////////////////////////////////////////////////////////////////////

Field Sicherheit
{
 type		= T
 label	= "Sicherheit"
 start	= 01
 length	= 01
 min		= 0
 max		= 0
 transformation= "-"
 equ		= "-"
}

Field Meldedatum
{
 type		= DATE 
 label		= "Datum"
 start		= 01
 length		= 10
 min		= 10
 max		= 10
 transformation	= "-"
 equ		= "-"
}

Field Meldeeinrichtung
{
 type		= T
 label		= "Meldeeinrichtung"
 start		= 12
 length		= 09
 min		= 0
 max		= 09
 transformation	= "-"
 equ		= "-"
}

Field ArztID
{
 type		= T
 label		= "Arzt-ID"
 start		= 22
 length		= 08
 min		= 01
 max		= 08
 transformation	= "-"
 equ		= "-"
}

Field KrankenkassenNummer
{
 type           = T
 label          = "Krankenkassen Nummer"
 start          = 31
 length         = 07
 min            = 0
 max            = 07
 transformation = "-"
 equ            = "*"
}

Field VersichertenNummer1
{
 type           = HIC
 label          = "Versicherten Nummer 1"
 start          = 39
 length         = 12
 min            = 0
 max            = 12
 transformation = "-"
 equ            = "*"
}

Field VersichertenNummer2
{
 type           = HIC
 label          = "Versicherten Nummer 2 (Gesundheitskarte)"
 start          = 52
 length         = 10
 min            = 0
 max            = 10
 transformation = "-"
 equ            = "*"
}

Field Geburtsdatum
{
 type		= DATE
 label		= "Geburtsdatum"
 start		= 69
 length		= 04
 min		= 04
 max		= 10
 transformation	= "-"
 equ		= "+"
}

Field Titel
{
 type		= T
 label		= "Titel"
 start		= 74
 length		= 15
 min		= 0
 max		= 0
 transformation	= "-"
 equ		= "*"
}

Field Vorname
{
 type           = N
 label          = "Vorname"
 start          = 90
 length         = 28
 min            = 01
 max            = 28
 transformation = "-:D[F]:P[*]"
 equ            = "+"
}

Field Namenszusatz
{
 type		= N
 label		= "Namenszusatz"
 start		= 119
 length		= 15
 min		= 0
 max		= 0
 transformation	= "-"
 equ		= "-"
}

Field Familienname
{
 type		= N
 label		= "Familienname"
 start		= 135
 length		= 28
 min		= 2
 max		= 28
 transformation	= "-:D[N]:P[*]"
 equ		= "+:1"
}


Field Geschlecht
{
 type		= SEX
 label		= "Geschlecht"
 start		= 164
 length		= 01
 min		= 01
 max		= 01
 transformation	= "-"
 equ		= "+"
}

Field Geburtsname
{
 type           = N
 label          = "Geburtsname"
 start          = 166
 length         = 28
 min            = 0
 max            = 0
 transformation = "-:D[N]:P[*]"
 equ            = "-:1"
}

Field WohnortPLZ
{
 type           = T
 label          = "Postleitzahl"
 start          = 195
 length         = 7
 min            = 0
 max            = 0
 transformation = "-"
 equ            = "*"
}

Field WohnortName
{
 type           = T
 label          = "Wohnort"
 start          = 203
 length         = 22
 min            = 0
 max            = 0
 transformation = "-"
 equ            = "-"
}

Field Strasse_Hausnummer
{
 type           = T
 label          = "Strasse/Hausnummer"
 start          = 226
 length         = 28
 min            = 0
 max            = 0
 transformation = "-"
 equ            = "-"
}

Field TelefonNr
{
 type		= T
 label		= "Telefonnummer"
 start		= 255
 length		= 30
 min		= 0
 max		= 0
 transformation	= "-"
 equ		= "-"
}

Field FaxNr
{
 type		= T
 label		= "Faxnummer"
 start		= 286
 length		= 30
 min		= 0
 max		= 0
 transformation	= "-"
 equ		= "-"
}

Field eMail
{
 type		= T
 label		= "eMail"
 start		= 317
 length		= 40
 min		= 0
 max		= 0
 transformation	= "-"
 equ		= "-"
}


Field GeburtsortPLZ
{
 type           = T
 label          = "Geburtsort PLZ"
 start          = 358
 length         = 7
 min            = 0
 max            = 0
 transformation = "-"
 equ            = "*"
}

Field GeburtsortName
{
 type           = T
 label          = "Geburtsort"
 start          = 366
 length         = 22
 min            = 0
 max            = 0
 transformation = "-"
 equ            = "*"
}

Field GeburtsWohnortPLZ
{
 type           = T
 label          = "Geburtswohnort PLZ"
 start          = 389
 length         = 7
 min            = 0
 max            = 0
 transformation = "-"
 equ            = "-"
}

Field GeburtsWohnortName
{
 type           = T
 label          = "Geburtswohnort"
 start          = 397
 length         = 22
 min            = 0
 max            = 0
 transformation = "-"
 equ            = "-"
}

Field KontaktTitel
{
 type 		= T
 label		= "Kontakt Titel"
 start		= 420
 length		= 15
 min		= 0
 max		= 0
 transformation	= "-"
 equ		= "-"
}

Field KontaktVorname
{
 type 		= T
 label		= "Kontakt Vorname"
 start		= 436
 length		= 28
 min		= 0
 max		= 0
 transformation	= "-"
 equ		= "-"
}
Field KontaktNamenszusatz
{
 type 		= T
 label		= "Kontakt Namenszusatz"
 start		= 465
 length		= 15
 min		= 0
 max		= 0
 transformation	= "-"
 equ		= "-"
}

Field KontaktFamilienname
{
 type 		= T
 label		= "Kontakt Familienname"
 start		= 481
 length		= 28
 min		= 0
 max		= 0
 transformation	= "-"
 equ		= "-"
}

Field KontaktWohnortPLZ
{
 type 		= T
 label		= "Kontakt PLZ"
 start		= 510
 length		= 7
 min		= 0
 max		= 0
 transformation	= "-"
 equ		= "-"
}

Field KontaktWohnortName
{
 type 		= T
 label		= "Kontakt Wohnort"
 start		= 518
 length		= 22
 min		= 0
 max		= 0
 transformation	= "-"
 equ		= "-"
}

Field KontaktStrasse_Hausnummer
{
 type           = T
 label          = "Kontakt Strasse/Hausnummer"
 start          = 541
 length         = 28
 min            = 0
 max            = 0
 transformation = "-"
 equ            = "-"
}

Field KontaktTelefonNr
{
 type           = T
 label          = "Kontakt Telefonnummer"
 start          = 570
 length         = 30
 min            = 0
 max            = 0
 transformation = "-"
 equ            = "-"
}

Field KontaktFaxNr
{
 type           = T
 label          = "Kontakt Faxnummer"
 start          = 601
 length         = 30
 min            = 0
 max            = 0
 transformation = "-"
 equ            = "-"
}

Field KontakteMail
{
 type           = T
 label          = "Kontakt eMail"
 start          = 632
 length         = 40
 min            = 0
 max            = 0
 transformation = "-"
 equ            = "-"

}

Field Studienteilnahme
{
 type 		= T
 label		= "Studienteilnahme"
 start		= 673
 length		= 40
 min		= 0
 max		= 0
 transformation	= "-"
 equ		= "-"
}
///////////////////////////////////////////////////////////////////////////////

Result S0_01_AMB
{
 pid            = 0
 update         = 0
 message        = "Es wurden mehrere Flle mit identischen Daten gefunden. Eine PID-Vergabe ist daher nicht mglich.<br><br>Bitte melden Sie dieses Ereignis an den <a href='mailto:?subject=Homonym'>Webmaster</A>!<br><br>Bitte arbeiten Sie zunchst ohne PID."
}

Result S0_01_DIR
{
 pid		= 1
 update		= 0
 message	= "Es wurde ein passender Fall gefunden. Da die Eingabe als unsicher markiert war, ist  eine Fehlzuordnung ist nicht mit absoluter Sicherheit auszuschlieen.<br><br>Sie knnen den PID mit Kopieren/Einfgen (Copy & Paste) in andere Dokumente einfgen."
}

Result S0_02_AMB
{
 pid            = 0
 update         = 0
 message        = "Es wurden mehrere Flle mit identischen Daten gefunden. Eine PID-Vergabe ist daher nicht mglich.<br><br>Bitte melden Sie dieses Ereignis an den <a href='mailto:?subject=Homonym'>Webmaster</A>!<br><br>Bitte arbeiten Sie zunchst ohne PID."
}

Result S0_02_DIR
{
 pid            = 1
 update         = 1
 message        = "Sie knnen den PID mit Kopieren/Einfgen (Copy & Paste) in andere Dokumente einfgen.<br><br><em>Bemerkung</em>: Die ergnzenden Angaben waren unvollstndig oder haben sich gendert."
}

Result S0_03_AMB
{
 pid            = 0
 update         = 0
 message        = "Es wurden mehrere Flle mit identischen Daten gefunden. Eine PID-Vergabe ist daher nicht mglich.<br><br>Bitte melden Sie dieses Ereignis an den <a href='mailto:?subject=Homonym'>Webmaster</A>!<br><br>Bitte arbeiten Sie zunchst ohne PID."
}

Result S0_03_DIR
{
 pid		= 1
 update		= 1
 message	= "Es wurde ein passender Fall gefunden. Da die Eingabe als unsicher markiert war, ist  eine Fehlzuordnung ist nicht mit absoluter Sicherheit auszuschlieen.<br><br>Sie knnen den PID mit Kopieren/Einfgen (Copy & Paste) in andere Dokumente einfgen."
}

Result S0_04_AMB
{
 pid            = 0
 update         = 0
 message        = "Es wurden mehrere Flle mit identischen Daten gefunden. Eine PID-Vergabe ist daher nicht mglich.<br><br>Bitte melden Sie dieses Ereignis an den <a href='mailto:?subject=Homonym'>Webmaster</A>!<br><br>Bitte arbeiten Sie zunchst ohne PID."
}

Result S0_04_DIR
{
 pid		= 1
 update		= 1
 message	= "Es wurde ein passender Fall gefunden. Da die Eingabe als unsicher markiert war, ist  eine Fehlzuordnung ist nicht mit absoluter Sicherheit auszuschlieen.<br><br>Sie knnen den PID mit Kopieren/Einfgen (Copy & Paste) in andere Dokumente einfgen."
}

Result S0_05_AMB
{
 pid            = 0
 update         = 0
 message        = "Es wurden mehrere hnliche Flle gefunden. Die Wahrscheinlichkeit reicht fr eine hinreichend sichere Zuordnung nicht aus.<br><br>Bitte arbeiten Sie zunchst ohne PID und versuchen Sie, weitere odere genauere Daten zu erhalten."
}

Result S0_05_DIR
{
 pid		= 1
 update		= 0
 message	= "Es wurde ein sehr hnlicher Fall gefunden. Dessen PID wird mit Vorbehalt ausgegeben.<br>Sie knnen den PID mit Kopieren/Einfgen (Copy & Paste) in andere Dokumente einfgen.<br><strong>bitte kennzeichnen Sie bis auf weiteres den PID bei jeder Verwendung mit einem Fragezeichen.</strong>"
}

Result S0_06_AMB
{
 pid            = 0
 update         = 0
 message        = "Es wurden mehrere hnliche Flle gefunden. Die Wahrscheinlichkeit reicht fr eine hinreichend sichere Zuordnung nicht aus.<br><br>Bitte arbeiten Sie zunchst ohne PID und versuchen Sie, weitere odere genauere Daten zu erhalten."
}

Result S0_06_DIR
{
 pid		= 0
 update		= 0
 message	= "Es wurden ein hnlicher Fall gefunden. Die Wahrscheinlichkeit reicht fr eine hinreichend sichere Zuordnung nicht aus.<br><br>Bitte arbeiten Sie zunchst ohne PID und versuchen Sie, weitere odere genauere Daten zu erhalten."
}



Result S1_01_DIR
{
 pid		= 1
 update		= 1
 message	= "Sie knnen den PID mit Kopieren/Einfgen (Copy & Paste) in andere Dokumente einfgen."
}

Result S1_01_AMB
{
 pid		= 0
 update		= 0
 message	= "Es wurden mehrere Flle mit identischen Daten gefunden. Eine PID-Vergabe ist daher nicht mglich.<br><br>Bitte melden Sie dieses Ereignis unmittelbat an den <a href='mailto:?subject=Homonym'>Webmaster</A>!<br><br>Bitte arbeiten Sie zunchst ohne PID."
}


Result S1_02_DIR
{
 pid		= 1
 update		= 1
 message	= "Sie knnen den PID mit Kopieren/Einfgen (Copy & Paste) in andere Dokumente einfgen."
}

Result S1_02_AMB
{
 pid		= 0
 update		= 0
 message	= "Es wurden mehrere Flle mit identischen Daten gefunden. Eine PID-Vergabe ist daher nicht mglich.<br><br>Bitte melden Sie dieses Ereignis unmittelbat an den <a href='mailto:?subject=Homonym'>Webmaster</A>!<br><br>Bitte arbeiten Sie zunchst ohne PID."
}

Result S1_03_AMB
{
 pid		= 0
 update		= 0
 message	= "Es wurden mehrere Flle mit identischen Daten gefunden. Eine PID-Vergabe ist daher nicht mglich.<br><br>Bitte melden Sie dieses Ereignis unmittelbat an den <a href='mailto:?subject=Homonym'>Webmaster</A>!<br><br>Bitte arbeiten Sie zunchst ohne PID."
}

Result S1_03_DIR
{
 pid		= 1
 update		= 1
 message	= "Es wurde ein passender, als unsicher markierter Fall gefunden. Eine Fehlzuordnung ist nicht mit absoluter Sicherheit auszuschlieen.<br><br>Sie knnen den PID mit Kopieren/Einfgen (Copy & Paste) in andere Dokumente einfgen."
}

Result S1_04_AMB
{
 pid		= 0
 update		= 0
 message	= "Es wurden mehrere Flle mit identischen Daten gefunden. Eine PID-Vergabe ist daher nicht mglich.<br><br>Bitte melden Sie dieses Ereignis unmittelbat an den <a href='mailto:?subject=Homonym'>Webmaster</A>!<br><br>Bitte arbeiten Sie zunchst ohne PID."
}

Result S1_04_DIR
{
 pid		= 1
 update		= 1
 message	= "Es wurde ein passender, als unsicher markierter Fall gefunden. Eine Fehlzuordnung ist nicht mit absoluter Sicherheit auszuschlieen.<br><br>Sie knnen den PID mit Kopieren/Einfgen (Copy & Paste) in andere Dokumente einfgen."
}

Result S1_05_AMB
{
 pid		= 0
 update		= 0
 message	= "Es wurden mehrere hnliche Flle gefunden. Die Wahrscheinlichkeit reicht fr eine hinreichend sichere Zuordnung nicht aus.<br><br>Bitte arbeiten Sie zunchst ohne PID und versuchen Sie, weitere odere genauere Daten zu erhalten."
}

Result S1_05_DIR
{
 pid		= 1
 update		= 0
 message	= "Es wurde ein sehr hnlicher Fall gefunden. Dessen PID wird mit Vorbehalt ausgegeben.<br>Sie knnen den PID mit Kopieren/Einfgen (Copy & Paste) in andere Dokumente einfgen.<br><strong>bitte kennzeichnen Sie bis auf weiteres den PID bei jeder Verwendung mit einem Fragezeichen.</strong>"
}

Result S1_06_DIR
{
 pid		= 0
 update		= 0
 message	= "Es wurde ein hnlicher Fall gefunden. Die Wahrscheinlichkeit reicht fr eine hinreichend sichere Zuordnung nicht aus.<br><br>Bitte arbeiten Sie zunchst ohne PID und versuchen Sie, weitere odere genauere Daten zu erhalten."
}

Result S1_06_AMB
{
 pid		= 0
 update		= 0
 message	= "Es wurden mehrere hnliche Flle gefunden. Die Wahrscheinlichkeit reicht fr eine hinreichend sichere Zuordnung nicht aus.<br><br>Bitte arbeiten Sie zunchst ohne PID und versuchen Sie, weitere odere genauere Daten zu erhalten."
}


Result NEG
{
 pid		= *
 update		= 0
 message	= "Sie knnen den PID mit Kopieren/Einfgen (Copy & Paste) in andere Dokumente einfgen."
}
////////////////////////////////////////////////////////////////////////////////

Test T_Start
{
 Prologue
 {
  input sure ?
 }

 Epilogue
 {
  0: T_S0_001
  1: T_S1_001
 }
}

///////////////////////////////////

Test T_S0_001
{
 Prologue
 {
  key		= 0
  sure		= 1
  exact		= 1
  optional 	= 1
 }
 Epilogue
 {
  0: T_S0_002
  1: S0_01_DIR
  *: S0_01_AMB
 }
}

///////////////////////////////////

Test T_S0_002
{
 Prologue
 {
  key		= 0
  sure		= 1
  exact		= 1
  optional 	= 0
 }
 Epilogue
 {
  0: T_S0_003
  1: S0_02_DIR
  *: S0_02_AMB
 }
}

///////////////////////////////////

Test T_S0_003
{
 Prologue
 {
  key		= 0
  sure		= 0
  exact		= 1
  optional 	= 1
 }
 Epilogue
 {
  0: T_S0_004
  1: S0_03_DIR
  *: S0_03_AMB
 }
}

///////////////////////////////////

Test T_S0_004
{
 Prologue
 {
  key		= 0
  sure		= 0
  exact		= 1
  optional 	= 0
 }
 Epilogue
 {
  0: T_S0_005
  1: S0_04_DIR
  *: S0_04_AMB
 }
}

///////////////////////////////////

Test T_S0_005
{
 Prologue
 {
  key		= 0
  sure		= *
  exact		= 0
  optional 	= 1
 }
 Epilogue
 {
  0: T_S0_006
  1: S0_05_DIR
  *: S0_05_AMB
 }
}

///////////////////////////////////

Test T_S0_006
{
 Prologue
 {
  key		= 0
  sure		= *
  exact		= 0
  optional 	= 0
 }
 Epilogue
 {
  0: NEG
  1: S0_06_DIR
  *: S0_06_AMB
 }
}


///////////////////////////////////
///////////////////////////////////


Test T_S1_001
{
 Prologue
 {
  key		= 0
  sure		= 1
  exact		= 1
  optional 	= 1
 }
 Epilogue
 {
  0: T_S1_002
  1: S1_01_DIR
  *: S1_01_AMB
 }
}

///////////////////////////////////

Test T_S1_002
{
 Prologue
 {
  key		= 0
  sure		= 1
  exact		= 1
  optional 	= 0
 }
 Epilogue
 {
  0: T_S1_003
  1: S1_02_DIR
  *: S1_02_AMB
 }
}

///////////////////////////////////

Test T_S1_003
{
 Prologue
 {
  key		= 0
  sure		= 0
  exact		= 1
  optional 	= 1
 }
 Epilogue
 {
  0: T_S1_004
  1: S1_03_DIR
  *: S1_03_AMB
 }
}

///////////////////////////////////

Test T_S1_004
{
 Prologue
 {
  key		= 0
  sure		= 0
  exact		= 1
  optional 	= 0
 }
 Epilogue
 {
  0: T_S1_005
  1: S1_04_DIR
  *: S1_04_AMB
 }
}

///////////////////////////////////

Test T_S1_005
{
 Prologue
 {
  key		= 0
  sure		= 0
  exact		= 0
  optional 	= 1
 }
 Epilogue
 {
  0: T_S1_006
  1: S1_05_DIR
  *: S1_05_AMB
 }
}

///////////////////////////////////

Test T_S1_006
{
 Prologue
 {
  key		= 0
  sure		= 0
  exact		= 0
  optional 	= 0
 }
 Epilogue
 {
  0: NEG
  1: S1_06_DIR
  *: S1_06_AMB
 }
}



////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

