/******************************************************************************/
/* psx-bci.c                                      Binary Conversion Interface */
/******************************************************************************/
/** @file psx-bci.c Binary Conversion Interface - Source Code File
 * Function supporting the conversion of a number into a binary number used in
 * PDI module.
 */


#include "psx.h"

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/

/******************************************************************************/
/** binary conversion interface
 * @param n input number
 * @param b binary number
 * @param a string
 * @param c PSX_STR (result of conversion)
 */

BOOL bci_cvt (NUM n,NUM b,char * a,PSX_STR c)
{
 char r [1000];
 IDX i;

 if (a == NULL || c == NULL)
  return (FALSE);

 if (n == 0)
 {
  strcpy (c,"0");
  return (TRUE);
 }

 i = sizeof (r);
 r [--i] = '\0';               // close string with binary Null, then decrement i

 while (n > 0)
 {
  IDX j;

  j = n % b;               
  n /= b;
  r [--i] = a [j];             // fill string from back
 }

 strcpy (c,r + i);             // copy last two elements to c

 return (TRUE);
}



/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


