/******************************************************************************/
/* psx-blk.h                                   Block Management Interface     */
/******************************************************************************/
/** @file psx-blk.h Block Management Interface - Header File
 * This module can be used to create, handle and delete a memory block. 
 * For example the html creation is handled by using memory blocks.
 * Defined Structure for using the Block Management Interfce features:
 * - PSX_BLK
 */
 
#ifndef _psx_blk_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/
/** PSX Block Structure */
SYS_STRUCTURE (PSX_BLK)
{
 PTR ptr;                               /**< block start address              */
 NUM len;                               /**< length of block content          */
 NUM siz;                               /**< allocation size                  */
 IDX idx;                               /**< index position                   */
};

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

LINKAGE	BOOL	blk_create	(PSX_BLK ** blk);
LINKAGE	BOOL	blk_delete	(PSX_BLK ** blk);
LINKAGE	BOOL	blk_clr		(PSX_BLK * blk);
LINKAGE	BOOL	blk_copy	(PSX_BLK * blk,PSX_BLK * src);
LINKAGE	BOOL	blk_read	(PSX_BLK * blk,PTR p,NUM n);
LINKAGE	BOOL	blk_write	(PSX_BLK * blk,PTR p,NUM n);
LINKAGE	BOOL	blk_setpos	(PSX_BLK * blk,IDX pos);
LINKAGE	BOOL	blk_getpos	(PSX_BLK * blk,IDX * pos);
LINKAGE	BOOL	blk_put		(PSX_BLK * blk,const char * src,NUM n);
LINKAGE	BOOL	blk_put_s	(PSX_BLK * blk,const char * src);
LINKAGE	BOOL	blk_get_s	(PSX_BLK * blk,char ** dst);
LINKAGE	BOOL	blk_printf	(PSX_BLK * blk,char * fmt,...);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_blk_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


