/******************************************************************************/
/* cci-lex.h                                  Compiler Construction Interface */
/******************************************************************************/
/** @file cci-lex.h Compiler Construction Interface - Header File
 * Definitions of Lex Type values supporting the Compiler Construction Interface.
 */
 
/* include cci-lex.h in *.l                                                   */

#ifndef _cci_lex_
#define _cci_lex_

/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Structure                                                                  */
/******************************************************************************/


/**************************************/
/* CCI Lex Type                       */
/**************************************/

#define	LTP_ZERO	0x00
#define	LTP_NL		0x01
#define	LTP_ID		0x02
#define	LTP_STR		0x03
#define	LTP_DEC		0x04
#define	LTP_INT		0x05
#define	LTP_HEX		0x06
#define	LTP_BIN		0x07
#define	LTP_OCT		0x08
#define	LTP_REAL	0x09
#define	LTP_CHR		0x0A
#define	LTP_ROP		0x0B
#define	LTP_CMT		0x0C

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

	int lex (CCI_LEX * _lex,int ltp,int id);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _cci_lex_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


