/******************************************************************************/
/* psx-cci.c                                  Compiler Construction Interface */
/******************************************************************************/
/** @file psx-cci.c Compiler Construction Interface - Source Code File
 * Functions to provide a Compiler Construction Interface.
 */
 
#include "psx.h"

/******************************************************************************/
// Private                                                                    //
/******************************************************************************/
/** get filename f from path pth
 * @param pth path to file f
 * @param f string pointer to filename 
 */

static BOOL cci_getfilename (char * pth,PSX_STR f)
{
 int n,i;
 char * p;

 if (pth == NULL || f == NULL)
  return (FALSE);

 if ((n = strlen (pth)) == 0)   // empty filename
 {
  strcpy (f,"");
  return (TRUE);
 }

 p = pth;

 for (i = n - 1;i >= 0;i--)
  if (pth [i] == '/')
  {
   p = pth + i + 1;             // get filename without directory path
   break;
  }

 strcpy (f,p);

 return (TRUE);
}

/******************************************************************************/
/* CCI Instance                                                               */
/******************************************************************************/

CCI cci;

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/
/** Initialize scanner and parser objects
 * @param cfg pointer to cci configuration
 */

BOOL cci_cfg (CCI_CFG * cfg)
{
 cci.scn = cfg -> scn;
 cci.psr = cfg -> psr;
 strcpy (cci.input,cfg -> input);

 return (TRUE);
}

/******************************************************************************/
/** open input file and link it to scanner
 */
	
BOOL cci_init (void)
{
 FILE * f;

 if (cci.scn == NULL)
  return (FALSE);

 if ((f = fopen (cci.input,"r")) == NULL)
 {
  printf ("file open error [%s]\n",cci.input);
  return (FALSE);
 }

 *cci.scn -> yyin = f;
 *cci.scn -> yy_flex_debug = 1;

 cci.error = FALSE;

 return (TRUE);
}

/******************************************************************************/
/** closes input file
 */

BOOL cci_exit (void)
{
 if (cci.scn == NULL)
  return (FALSE);

 if (*cci.scn -> yyin)
 {
  fclose (*cci.scn -> yyin);
  *cci.scn -> yyin = NULL;
 }

 return (TRUE);
}

/******************************************************************************/
/** get error message
 * @param fmt pointer to format string
 * @param ... variable parameter list
 */

BOOL cci_error (const char * fmt,...)
{
 va_list l;
 IDX line = 0;
 char s [1000],t[1000];
 PSX_STR f;

 va_start (l,fmt);             // start variable argument list 
 vsprintf (s,fmt,l);
 va_end (l);


 if (strcmp (s,"parse error") == 0)
 {
  if (cci.error)
   return (TRUE);
  strcpy (s,"syntax error");
 }

 if (cci.scn)
  line = cci.scn -> line + 1;

// printf ("[%08d]: %s\n",line,s);
 cci_getfilename (cci.input,f);
 sprintf (t,"%s [%04d]: %s",f,line,s);
 psx_put ("%s",t);

 cci.error = TRUE;

 return (TRUE);
}

/******************************************************************************/
/** print everything from parameter list
 * @param fmt pointer to format string
 * @param ... variable parameter list
 */
 
BOOL cci_trace (char * fmt,...)
{
 va_list l;
 char s [1000];

 va_start (l,fmt);
 vsprintf (s,fmt,l);
 va_end (l);

// if (cci_Parser::active)
 // ; // line = cci_Scanner::active -> idx_line + 1;

 printf ("%s\n",s);

 return (TRUE);
}

/******************************************************************************/
/* under construction                                                         */
/*
int cci_execute (int ac,char ** av)
{
 int r;

// if (cci_Application::active == 0)
//  return (-1);

// r = cci_Application::active -> Execute ();

 return (r);
}
*/
/******************************************************************************/
/** start lex
 * @param ltp
 * @param id
 */

int cci_lex (int ltp,int id)
{
 int r;

 if (cci.scn == NULL)
  return (0);

 r = lex (cci.scn,ltp,id);

 return (r);
}

/******************************************************************************/
/* under construction                                                         */
/*
static int _cci_input (void)
{
// cci_Scanner * scn = cci_Scanner::active;
 int r;

// if (scn == 0)
//  return (0);

// r = scn -> input ();

 return (r);
}
*/

/*****************************************************************************/
//extern "C"
//{
/*
int cci_input (void)
{
 int r;

 r = _cci_input ();

 return (r);
}*/

//}

/******************************************************************************/

int cci_yylex (void)
{

// cci_Scanner * scn = cci_Scanner::active;
// cci_Token t;

 //ASSERT (scn != 0);

// if (scn == 0)
  return (0);

// if (!scn -> scan (&t))
  return (0);

 return (0); //t);
}

/******************************************************************************/

int /*__cdecl*/ yylex1 (void)
{
 return (cci_yylex ());
}

////////////////////////////////////////////////////////////////////////////////
// Scanner Procedure                                                          //
////////////////////////////////////////////////////////////////////////////////

CCI_SCANNERPROCEDURE (cci_scnprc)
{
 switch (cci_tok)
 {
  case CCI_TOK_NL:
  {
   if (cci.scn)
    cci.scn -> line++;
   break;
  }

  case CCI_TOK_ID:
  {
   //if (sym.get (tok -> txt,&tok -> id))
   // break;

   break;
  }

  default:
  {
   break;
  }

 }
 return (0);
}


/******************************************************************************/

int yyerror (const char * s)
{
 cci_error ("%s",s);
 exit (-1);
 return (-1);
}

/******************************************************************************/

int yywrap ()
{

 return (1);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


