/******************************************************************************/
/* psx-cci.h                                  Compiler Construction Interface */
/******************************************************************************/
/** @file psx-cci.h Compiler Construction Interface - Header File
 * Definitions supporting the Compiler Construction Interface:
 * - CCI Tokens
 * - CCI Relops (definitions for relational operators)
 * - CCI Expression Type
 * There are also some structures defined here:
 * - CCI_TOKEN
 * - CCI_LEX
 * - CCI_YACC
 * - CCI
 * - CCI_CFG
 * The Compiler Construction Interface provides Functions for the
 * construction of a compiler. This Compiler is used to scan and parse the
 * input configuration files.
 */
 
#ifndef _psx_cci_
#define _psx_cci_

/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

// #include <sys.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>

/******************************************************************************/
/* Messaging                                                                  */
/******************************************************************************/


/**************************************/
/* CCI Tokens                         */
/**************************************/

#define CCI_TOK_ZERO          0x00         // zero
#define CCI_TOK_NL            0x01         // new line
#define CCI_TOK_COMMENT       0x02         // comment
#define CCI_TOK_INT	          0x03         // integer
#define CCI_TOK_REAL          0x04         // real
#define CCI_TOK_CHR	          0x05         // character
#define CCI_TOK_STR	          0x06         // string
#define CCI_TOK_ID	          0x07         // identifier
#define CCI_TOK_ERROR 	      0x08         // error

////////////////////////////////////////
// CCI Relops                         // relational operators
////////////////////////////////////////

#define CCI_ROP_ZERO	0x00	               // CDI_ROP_ZERO
#define CCI_ROP_EQ	  0x01	               // CDI_ROP_EQ
#define CCI_ROP_NE	  0x02	               // CDI_ROP_NE
#define CCI_ROP_LS	  0x03	               // CDI_ROP_LS
#define CCI_ROP_LE	  0x04	               // CDI_ROP_LE
#define CCI_ROP_GR	  0x05	               // CDI_ROP_GR
#define CCI_ROP_GE	  0x06	               // CDI_ROP_GE

/**************************************/
/* CCI Expression Type                */
/**************************************/

#define CCI_ETP_ZERO          0x00         // zero
#define CCI_ETP_CON           0x01         // constant
#define CCI_ETP_VAR           0x02         // variable
#define CCI_ETP_PLUS          0x03         // plus expression
#define CCI_ETP_MINUS         0x04         // minus expression
#define CCI_ETP_MUL           0x05         // multiplication
#define CCI_ETP_DIV           0x06         // division
#define CCI_ETP_AND           0x07         // logical operator AND
#define CCI_ETP_OR            0x08         // logical operator OR
#define CCI_ETP_NOT           0x09         // logical operator NOT

/******************************************************************************/
/* Types                                                                      */
/******************************************************************************/

/**************************************/
/** Token                             */
/**************************************/

typedef struct
{
 int    id;
 int    itg;
 double dbl;
 float  flt;
 char   chr;
 char   txt [0xFFFF];
 int    opr;
 IDX    idx;
 NUM    num;
} CCI_TOKEN;

/**************************************/
/* Scanner Delegate Procedure         */
/**************************************/

typedef int (* CCI_SCNPRC) (int cci_tok,CCI_TOKEN * tok);
#define CCI_SCANNERPROCEDURE(prc) int prc (int cci_tok,CCI_TOKEN * tok)

/**************************************/
/** lex                               */
/**************************************/

typedef struct _CCI_LEX
{
 FILE ** yyin;
 FILE ** yyout;
 char ** yytext;
 int *   yy_flex_debug;
 int  (* input) (void);
 int  (* yylex) (void);
 int     line;

 // initialized from above

 CCI_SCNPRC     scnprc;
 CCI_TOKEN *    yylval;
} CCI_LEX;


/**************************************/
/* yacc                               */
/**************************************/

typedef struct
{
 int *  yydebug;
 CCI_TOKEN * yylval;
 int (* yyparse ) (void);
} CCI_YACC;

/**************************************/
/* CCI                                */
/**************************************/

typedef struct
{
 CCI_LEX  * scn;
 CCI_YACC * psr;
 char input [1000];
 BOOL error;
} CCI;

/**************************************/
/* Config                             */
/**************************************/

typedef struct
{
 CCI_LEX  * scn;
 CCI_YACC * psr;
 char input [1000];
} CCI_CFG;


/******************************************************************************/
// lex/yacc                                                                   //
/******************************************************************************/

////////////////////////////////////////
// scanner callback table             //
////////////////////////////////////////

//typedef struct _CCI_LEX CCI_LEX;


/******************************************************************************/
// Export                                                                     //
/******************************************************************************/

#include "psx-cci-lex.h"

//#include <cci-lex.h>
//#include <cci-sbt.h>
//#include <cci-obt.h>

/**************************************/
/* Tokens                             */
/**************************************/

typedef DWORD TOKEN;

/**************************************/
/* Export                             */
/**************************************/

// #if (SYS_LNG == SYS_CPP)

// #include <cci_Object.hpp>
// #include <cci_Objecttable.hpp>
// #include <cci_Symboltable.hpp>
// #include <cci_Token.hpp>
// #include <cci_Scanner.hpp>
// #include <cci_Parser.hpp>
// #include <cci_Application.hpp>
// #endif

extern CCI cci;

/******************************************************************************/
// Service                                                                    //
/******************************************************************************/

	BOOL	cci_cfg		(CCI_CFG * cfg);
	BOOL	cci_init	(void);
	BOOL	cci_exit	(void);
	
	BOOL	cci_error	(const char * fmt,...);
	BOOL	cci_trace	(char * fmt,...);
	
	
	
int cci_execute (int ac,char ** av);

// special
	int	cci_lex		(int ltp,int id);

//extern "C" int cci_input   (void);

int cci_yylex   (void);

CCI_SCANNERPROCEDURE (cci_scnprc);


//#define YYSTYPE CCI_TOKEN
//#define YY_DECL static int yylex (void)

int yyerror (const char * s);
int yywrap ();

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_cci_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


