/******************************************************************************/
/* psx-cgi.h                                         Common Gateway Interface */
/******************************************************************************/
/** @file psx-cgi.h Common Gateway Interface - Header File
 * Definitions and prototypes supporting the CGI.
 * Typedefinitions:
 * - CGI_PAR
 * - CGI_ACC
 * - CGI
 */
 
#ifndef _psx_cgi_
#define _psx_cgi_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/* Definition                                                                 */
/******************************************************************************/

/**************************************/
/* Request Method                     */
/**************************************/

#define CGI_REQ_ZERO	0
#define CGI_REQ_GET	  1
#define CGI_REQ_POST	2

/**************************************/
/* Content Type                       */
/**************************************/

#define CGI_CNT_ZERO	0
#define CGI_CNT_FORM	1

/******************************************************************************/
/* Type                                                                       */
/******************************************************************************/
/** parameter struct.
 * Stores attribute-value pairs, used to store CGI variables. */
typedef struct _CGI_PAR                
{
 char * sym;                            /**< parameter name   */
 char * val;                            /**< value            */
} CGI_PAR;

/**************************************/
/** access structure.
 ** Stores access information for CGI access.                  */
typedef struct _CGI_ACC               
{
 PSX_STR tsp;                           /**< time stamp       */
 PSX_STR dat;                           /**< date             */
 PSX_STR tim;                           /**< time             */
 PSX_STR usr;                           /**< user             */
 PSX_STR adr;                           /**< address          */
 PSX_STR hst;                           /**< host             */
 PSX_STR prt;                           /**< port             */
} CGI_ACC;

/**************************************/
/** cgi information structure.
 * Stores CGI variables in substructure par.        
 */
typedef struct _CGI
{
 CGI_PAR * par;                         /**< parameter                 */
 int       par_num;                     /**< number of parameter       */
 char *    stg;                         /**< input string              */
 BOOL      cnt;                         /**< content? (0=zero, 1=form) */
} CGI;

extern CGI cgi;

/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

BOOL	cgi_init	();
BOOL	cgi_exit	();

BOOL	cgi_get		(const char * atr,char ** val);
BOOL	cgi_put_l	(const char * fmt,va_list l);
BOOL	cgi_put		(const char * fmt,...);

BOOL	cgi_acc_get	(CGI_ACC * acc);
BOOL	cgi_dic_get	(PSX_DIC * dic);

/******************************************************************************/
/* Macro                                                                      */
/******************************************************************************/

#define CGI_PAR(i)	cgi.par [i]
#define CGI_SYM(i)	cgi.par [i].sym
#define CGI_VAL(i)	cgi.par [i].val
#define CGI_NUM		cgi.par_num

#define CGI_PAR_ITERATE(i)	for (i = 0;i < CGI_NUM;i++)

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_cgi_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


