/******************************************************************************/
/* psx-cmd-gui.inl                                          Command Interface */
/******************************************************************************/
/** @file psx-cmd-gui.inl Command Interface: Graphical User Interface Command - Source Code File
 * Functions providing a graphical user interface by using html.
 * The GUI Command is only used in addition to the CGI Command. In order to
 * provide the usage of a web interface, html code is generated during the
 * process.
 * The main context structure used by the interface is of type CTX_GUI_CGI.
 */

/** Graphical User Interface CGI context  */
typedef struct _CTX_GUI_CGI
{
 GUI_CTX * gux;           /**< GUI context */
} CTX_GUI_CGI;


/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/
/** initialize cgi
 * @param ctx pointer to GUI-CGI context
 * @param csp pointer to command specification
 */
static BOOL gui_cgi_init (CTX_GUI_CGI * ctx,PSX_CSP * csp)
{
 GUI_CFG cfg;

 if (ctx == NULL || csp == NULL)
  return (FALSE);

 memset (ctx,0,sizeof (*ctx));
 memset (&cfg,0,sizeof (cfg));

 cfg.sys = csp -> ctx.gui.cgi.sys;
 cfg.dbg = csp -> ctx.gui.cgi.dbg;
 
 if (!gui_create (&ctx -> gux))
  return (FALSE);

 if (!gui_init (ctx -> gux,&cfg))
 {
  return (FALSE);
 }

 return (TRUE);
}

/******************************************************************************/
/** exit gui
 * @param ctx pointer to GUI-CGI context
 */

static BOOL gui_cgi_exit (CTX_GUI_CGI * ctx)
{
 BOOL r = TRUE;

 if (ctx == NULL)
  return (FALSE);

 if (ctx -> gux)                 
 {
  if (!gui_exit (ctx -> gux))
   r = FALSE;

  gui_delete (&ctx -> gux);
 }

 return (r);
}

/******************************************************************************/
/** run graphical user interface (cgi)
 * @param ctx pointer to GUI-CGI context
 */
  
static BOOL gui_cgi_run (CTX_GUI_CGI * ctx)
{
 BOOL r = TRUE;

 if (ctx == NULL)
  r = FALSE;
  //return (FALSE);     

 if (!gui_run (ctx -> gux))  // send HTML document to stdout
  r = FALSE;
  //return (FALSE);

 return(r);
}

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/


/******************************************************************************/
/** commandline entry point for cgi execution
 * @param csp pointer to command specification
 */

static int cmd_gui_cgi (PSX_CSP * csp)
{
 CTX_GUI_CGI ctx;
 int r = 0;
 CGI_ACC acc;
 PSX_STR t;

 cgi_acc_get (&acc);

 LOG (MOD,"cgi request [%s]",acc.adr);

 if (csp == NULL)
  return (-1);
 
 if (!gui_cgi_init (&ctx,csp))
 {
  LOG (MOD,"cgi request: init failed");
  return (-1);
 }

 if (!gui_cgi_run (&ctx))
  r = -1;

 if (!gui_cgi_exit (&ctx))
  r = -1;

 LOG (MOD,"cgi request: exit, result: %s", (r == 0) ? "ok" : "failed");

 return (r);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


