/******************************************************************************/
/* psx-cmi.h                                       Cipher Management Interface */
/******************************************************************************/
/** @file psx-cmi.h Cipher Management Interface - Header File
 * Definitions supporting the Cipher Management Interface.
 * Structures provided by this module:
 * - CMI_CFG
 * - CMI_CTX
 * There are also definitions for command specification (encoding or decoding).  
 */
 
#ifndef _psx_cmi_
#define _psx_cmi_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/


typedef BYTE CMI_CMD;

#define	CMI_CMD_ZERO	0x00
#define	CMI_CMD_ENC	0x01
#define	CMI_CMD_DEC	0x02
#define	CMI_CMD_CVT	0x03

/** Cipher Management Configuration structure */
typedef struct _CMI_CFG
{
 CMI_CMD cmd;                  /**< cipher management options          */
 char *  iff;                  /**< input format file                  */
 char *  off;                  /**< output format file                 */
 char *  idf;                  /**< input data file                    */
 char *  odf;                  /**< output data file                   */
 CPE     enc;                  /**< encoding                           */
 long    pos;                  /**< start position                     */
 BOOL    bat;                  /**< batch mode                         */
 BOOL    hdn;                  /**< headings (output format help)      */
 ICS     ics;                  /**< input character set; added 11.11.2004 */
 PSX_STR del; /**< :BG: delimiter for csv input */
 PSX_STR key;                  /**< key                                */
} CMI_CFG;

/******************************************************************************/
/** cipher management context structure                                       */
typedef struct _CMI_CTX
{
 CMI_CMD   cmd;                         /**< cipher management options          */
 PSX_FSP * ifs;                         /**< input format specification         */
 PSX_FSP * ofs;                         /**< output format specification        */
 char *    off;                         /**< output format file                 */
 FILE *    ids;                         /**< input data stream                  */
 FILE *    ods;                         /**< output data stream                 */
 PSX_REC * idr;                         /**< input record                       */
 PSX_REC * odr;                         /**< output record                      */
 CPE       enc;                         /**< encoding                           */
 long      pos;                         /**< start position                     */
 NUM       cnt;                         /**< count of processed records         */
 BOOL      bat;                         /**< batch mode                         */
 BOOL      hdn;                         /**< headings                           */
 ICS      ics;                          /**< input character set,added 11.11.2004 */
 PSX_STR   msg;                         /**< user output message                */
 TMI_TMG   tmg;                         /**< timing                             */
 PSX_STR   key;
 PSX_STR del;                        /**< :BG: delimiter for csv input */
} CMI_CTX;

typedef CMI_CTX PSX_CMX;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	cmi_create	(CMI_CTX ** ctx);
LINKAGE	BOOL	cmi_delete	(CMI_CTX ** ctx);

LINKAGE	BOOL	cmi_init	(CMI_CTX * ctx,CMI_CFG * cfg);
LINKAGE	BOOL	cmi_exit	(CMI_CTX * ctx);

LINKAGE	BOOL	cmi_run		(CMI_CTX * ctx);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_cmi_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

