/******************************************************************************/
/* psx-cni.c                                         Control Number Interface */
/******************************************************************************/
/** @file psx-cni.c Control Number Interface - Source Code File
 * Functions supporting the usage of md5 hashing. This includes a function for
 * logging values of several variables (source, raw and hex).
 */

#include "psx.h"

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/

#define CNI_LEN_MD5 MD5_LEN
#define CNI_LEN_RAW 23
#define CNI_LEN_HEX (CNI_LEN_MD5 << 1)

#define MOD PSX_MOD_CNI

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/
/** get length of textfield, length is encoded in CNI_LEN_RAW or CNI_LEN_HEX
 * @param txf specifies kind of textfield, values are TXF_RAW or TXF_HEX
 * @param len encoded length of textfield after invocation, possible values are
 *            CNI_LEN_RAW, CNI_LEN_HEX or '0', if txf is not valid
 */
 
BOOL cni_get_len (BYTE txf,NUM * len)
{
 if (len == NULL)
  return (FALSE);

 switch (txf)
 {
  case TXF_RAW: *len = CNI_LEN_RAW; break;
  case TXF_HEX: *len = CNI_LEN_HEX; break;
  default:      *len = 0;  return (FALSE);
 }

 return (TRUE);
}

/******************************************************************************/
/** get gap
 * @param txf kind of textfield, TXF_RAW or TXF_HEX
 * @param str
 */
 
BOOL cni_get_gap (BYTE txf,PSX_STR str)
{
 NUM n;

 if (!cni_get_len (txf,&n))    // get length of textfield
 {
  strcpy (str,"?");
  return (FALSE);
 }

 txt_gen_chr (str,' ',n); // generate string with n characters initialized with blanks

 return (TRUE);
}

/******************************************************************************/
/** log values of the variables src, raw and hex
 * @param src string pointer to a source text to be logged
 * @param raw string pointer to a raw encoded text
 * @param hex string pointer to a hex encoded text
 */
 
static BOOL cni_gen_log (char * src,char * raw,char * hex)
{
 char t [1000];

 LOG (MOD," details:");

 LOG (MOD," src = '%s'",src);

 LOG (MOD," raw = '%s'",raw);

 LOG (MOD," hex = '%s'",hex);

 return (TRUE);
}

/******************************************************************************/
/** generate string,
 * @param txt string to be encoded
 * @param stg BYTE pointer to string
 * @param len NUM pointer to length
 */

static BOOL cni_gen_stg (PSX_STR txt,BYTE * stg,NUM * len)
{
 char ctn [100],l_txt [100],l_hex [100],l_raw [100];
 NUM n;

 if (stg == NULL || len == NULL)
  return (FALSE);

 n = strlen (txt);
 strcpy (l_txt,txt);             

 if (!str_isnil (txt))
 {
  //md5bin (txt,stg);            
  memcpy (stg,txt,n + 1);
  md5_enc (stg,n + 1);           // hash stg
  *len = CNI_LEN_MD5;
 }
 else
  *len = 0;

 // raw data is now in stg

 cvt_b2a (stg,*len,TXF_RAW,l_raw);   // convert RAW to HEX
 cvt_b2a (stg,*len,TXF_HEX,l_hex);   // convert HEX to RAW
 cni_gen_log (l_txt,l_raw,l_hex);    // log values


 return (TRUE);
}

/******************************************************************************/
/** generate control numbers
 * @param txt text to be encoded
 * @param BYTE pointer to string (unsigned char)
 * @param len NUM pointer to length of strin (CNI_LEN_RAW or CNI_LEN_HEX)
 */
 
BOOL cni_gen (PSS_STR txt,BYTE * stg,NUM * len)
{
 NUM n;
 char ctn [1000];
 BYTE s [CPI_STG_MAX];

 if (txt == NULL || stg == NULL)
  return (FALSE);

 if (!cni_gen_stg (txt,s,len))     // generate string
  return (FALSE);

 memcpy (stg,s,*len);

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/







