/******************************************************************************/
/* psx-cpi-map.inl                                Cipher Management Interface */
/******************************************************************************/
/** @file psx-cpi-map.inl Cipher Management Interface: Map - Source Code File
 * Functions supporting the mapping of an input format to an output format.
 */
 
/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/
/** make string from input
 * @param str string pointer to string after invocation
 * @param mfm map format
 * @param s string pointer to source string, copied to str if matching map format
 * @param c string pointer, appended to s after '_'
 */

static BOOL cpi_str_make (char * str,MFM mfm,const char * s,const char * c)
{
 if (str == NULL)
  return (FALSE);

 strcpy (str,"");

 if (TEST (mfm,MFM_SYM) && s != NULL)
  strcat (str,s);							// append s to str 

 if (TEST (mfm,MFM_CMP) && !str_isnil(c))
 {
  if (str [0] != 0)
   strcat (str,"_");
  strcat (str,c);							// append _c
 }

 return (TRUE);
}

/******************************************************************************/
/** map input fsp to output fsp according tp transformation
 * @param ifs pointer to input format specification
 * @param idx item index
 * @param enc cipher encoding structure
 * @param pos pointer to position index
 * @param mfm output map format after invocation
 */

BOOL cpi_fsp_itm_map (PSX_FSP * ifs,IDX idx,PSX_FSP * ofs,CPE enc,IDX * pos,MFM mfm)
{
 NUM gap,k;
 FSP_ITM itm_def;

 if (ifs == NULL || ofs == NULL)
  return (FALSE);

 memset (&itm_def,0,sizeof (itm_def));					// get memory

 if (TEST (ifs -> itm [idx].tfm,TFM_ENC))				// test TFM encrypt
  fsp_tsp_ctt_get (ifs -> itm [idx].tfm,&itm_def.ctt);	// get ctt

 cpi_gap_get_len (enc,&gap);							// get gap length

 if (!TEST (ifs -> itm [idx].tfm,TFM_COL))				
  return (TRUE);

 /* decomposition */

 if (TEST (ifs -> itm [idx].tfm,TFM_DEC))
 {
  IDX j;

  for (j = 1;j <= 3;j++)
  {
   FSP_ITM itm = itm_def;

   itm.dtp = DTP_TEXT; // default

   cpi_str_make (itm.sym,mfm,ifs -> itm [idx].sym,cpi_sfx [j - 1]);

   if (pos)
    itm.pos = *pos;
   else
    itm.pos = 0;

   itm.len = gap;

   if (pos)
    *pos += gap + 1;

   if (!fsp_add (ofs,&itm))
    return (FALSE);
  }
 }
 else // ! dec
 {
  if (TEST (ifs -> itm [idx].tfm,TFM_CTN))
  {
   FSP_ITM itm = itm_def;

   itm.dtp = DTP_TEXT; // default
   cpi_str_make (itm.sym,mfm,ifs -> itm [idx].sym,""); // cpi_sfx [j - 1]);

   if (pos)
    itm.pos = *pos;
   else
    itm.pos = 0;

   itm.len = gap; // FEHLWERTBREITE;

   if (pos)
    *pos += gap + 1; // (FEHLWERTBREITE + 1);

   if (!fsp_add (ofs,&itm))
   {
    //fmt_delete (&f);
    return (FALSE);
   }
  }
  else // ! ctn
  {
   FSP_ITM itm  = itm_def;

   itm.dtp = DTP_TEXT; // default
   //strcpy (itm.var,fmt -> itm [idx].var);
   cpi_str_make (itm.sym,mfm,ifs -> itm [idx].sym,""); //cpi_sfx [j - 1]);

   if (pos)
    itm.pos = *pos;
   else
    itm.pos = 0;

   itm.len = ifs -> itm [idx].len;

   if (pos)
    *pos += (ifs -> itm [idx].len + 1);

   if (!fsp_add (ofs,&itm))
   {
    //fmt_delete (&f);
    return (FALSE);
   }
  }
 }

 if (TEST (ifs -> itm [idx].tfm,TFM_PHO))
 {
  if (TEST (ifs -> itm [idx].tfm,TFM_PHO_C))
  {
   FSP_ITM itm = itm_def;

   itm.dtp = DTP_TEXT; // default
   //sprintf (itm.var,"%s_%s",fmt -> itm [idx].var,cpi_sfx [3]);
   cpi_str_make (itm.sym,mfm,ifs -> itm [idx].sym,cpi_sfx [3]);

   if (pos)
    itm.pos = *pos;
   else
    itm.pos = 0;

   itm.len = gap;

   if (pos)
    *pos += gap + 1;

   if (!fsp_add (ofs,&itm))
    return (FALSE);
  }

  if (TEST (ifs -> itm [idx].tfm,TFM_PHO_H))
  {
   FSP_ITM itm = itm_def;

   itm.dtp = DTP_TEXT; // default
   cpi_str_make (itm.sym,mfm,ifs -> itm [idx].sym,cpi_sfx [4]);

   if (pos)
    itm.pos = *pos;
   else
    itm.pos = 0;

   itm.len = gap;

   if (pos)
    *pos += gap + 1;

   if (!fsp_add (ofs,&itm))
    return (FALSE);
  }
 }

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

