/******************************************************************************/
/* psx-cpi-tfm.inl                                           Cipher Interface */
/******************************************************************************/
/** @file psx-cpi-tfm.inl Cipher Interface: Transformation - Source Code File
 * Procedures implementing the controlnumber encipherment.
 *
 * Cipher Composition:
 *
 * Bit           Component
 *  0:--------->  C1
 *  1:--------->  C2
 *  2:--------->  C3
 *  3:--------->  PC
 *  4:--------->  PH
 *  5:
 *  6:
 *  7:       
 *                                    
 */
 
/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/
/** get key from psx.key or cpi.key
 * @param pointer to pointer to key string
 */

static BOOL cpi_get_key (char ** key)
{
 if (key == NULL)
  return (FALSE);

 if (!str_isnil (cpi_key))
  *key = cpi_key;
 else
  *key = psx.key;			// default from registry

 return (TRUE);
}

/******************************************************************************/
/** set length and control number of cmp struct
 * @param itm pointer to cipher interface record item
 * @param cmp component
 */

static BOOL cni_itm_prc_ctn_cmp (CPI_REC_ITM * itm,BYTE cmp)
{
 NUM len;

 if (!cni_gen (itm -> cmp [cmp].stg,itm -> cmp [cmp].stg,&len))
  return (FALSE);

 itm -> cmp [cmp].len = len;
 itm -> cmp [cmp].cnt = CPI_CNT_CTN;

 return (TRUE);
}

/******************************************************************************/
/** log control number
 * @param itm pointer to cipher interface record item
 */

static BOOL cni_itm_prc_ctn (CPI_REC_ITM * itm)
{
 BYTE txf;
 IDX i;

 if (itm == NULL)
  return (FALSE);

 // enctotxf (enc,&txf);

 for (i = 0;i < CMP_N;i++)
  if (TEST (itm -> cnc,BIT (i)))
  {
   PSX_STR t;

   strcpy (t,itm -> cmp [i].stg);

   if (!cni_itm_prc_ctn_cmp (itm,i))		// set length and controlnumber
    return (FALSE);

   LOG (PSX_MOD_CPI,"ctn: '%s'\n       -> '%s'",t,itm -> cmp [i].stg);
  }

 return (TRUE);
}

/******************************************************************************/
/** decompose item cmp string
 * @param itm pointer to cipher interface record item
 * @param dec decomposed component after invocation
 */

static BOOL cni_itm_prc_dec (CPI_REC_ITM * itm,BYTE dec)
{
 PSX_STR t,org;

 if (itm == NULL)
  return (FALSE);

 strcpy (org,itm -> cmp [CMP_N1].stg);
 strcpy (t,org);

 if (txt_isMultiPart (t) == 0)
 {
  strcpy (itm -> cmp [CMP_N1].stg,t);
 }
 else
 {
  txt_cvt_del (t);
  txt_dec (t,dec,itm -> cmp [CMP_N1].stg,itm -> cmp [CMP_N2].stg,itm -> cmp [CMP_N3].stg);
  itm -> cmp [CMP_N1].len = strlen (itm -> cmp [CMP_N1].stg);
  itm -> cmp [CMP_N2].len = strlen (itm -> cmp [CMP_N2].stg);
  itm -> cmp [CMP_N3].len = strlen (itm -> cmp [CMP_N3].stg);
 }

 LOG (PSX_MOD_CPI,"> tfm: dec: '%s'\n             C1: '%s'\n             C2: '%s'\n             C3: '%s'",org,itm -> cmp [CMP_N1].stg,itm -> cmp [CMP_N2].stg,itm -> cmp [CMP_N3].stg);

 return (TRUE);
}

/******************************************************************************/
/** recompose string and store in proper position
 * @param itm pointer to cipher interface record item
 * @param phc phonetic component
 */

// TODO: trim all strings before

static BOOL cni_itm_prc_pho (CPI_REC_ITM * itm,BYTE phc)
{
 PSX_STR t,org;

 if (itm == NULL)
  return (FALSE);

 strcpy (t,itm -> cmp [CMP_N1].stg);		// compose the string parts
 strcat (t,itm -> cmp [CMP_N2].stg);
 strcat (t,itm -> cmp [CMP_N3].stg);

 strcpy (org,t);

 switch (phc)
 {
  case PHO_COL:
   strcpy (itm -> cmp [CMP_PC].stg,t);
   pho (itm -> cmp [CMP_PC].stg,PHO_COL); // rely: "" -> ""
   itm -> cmp [CMP_PC].len = strlen (itm -> cmp [CMP_PC].stg);
   itm -> cmp [CMP_PC].cnt = CPI_CNT_TXT;
   LOG (PSX_MOD_CPI,"tfm: pho [C]: '%s'      -> '%s'",org,itm -> cmp [CMP_PC].stg);
   break;

  case PHO_HAN:
   strcpy (itm -> cmp [CMP_PH].stg,t);
   pho (itm -> cmp [CMP_PH].stg,PHO_HAN); // rely: "" -> ""
   itm -> cmp [CMP_PH].len = strlen (itm -> cmp [CMP_PH].stg);
   itm -> cmp [CMP_PC].cnt = CPI_CNT_TXT;
   LOG (PSX_MOD_CPI,"tfm: pho [H]: '%s'      -> '%s'",org,itm -> cmp [CMP_PH].stg);
   break;

  default:
   return (FALSE);
 }

 return (TRUE);
}

/******************************************************************************/
/** encode item component string
 * @param itm pointer to cipher interface record item
 * @param tsp transformation specification
 * @param enc cipher encoding information
 */

static BOOL cni_itm_prc_enc (CPI_REC_ITM * itm,TSP tsp,CPE enc)
{
 IDX i;
 BYTE txf;
 char * key;
 CTT ctt;
 PSX_STR ctt_sym;

 if (!fsp_tsp_ctt_get (tsp,&ctt))			// read encryption type (AES, IDEA) from tsp into ctt
  return (FALSE);

 cti_ctt_enc (ctt,ctt_sym);					// encode encryption type to string (for log message)

 enctotxf (enc,&txf);						// encode encoding (HEX/RAW) to string (for log message)
 cpi_get_key (&key);						// get key

 for (i = 0;i < CMP_N;i++)					// loop over components
  if (TEST (itm -> cnc,BIT (i)))			// check if component i is present for current item
  {
   switch (itm -> cmp [i].cnt)				// switch field type
   {
    case CPI_CNT_TXT:						// plaintext: encryption not supported
    {
     psx_put ("encryption currently for control numbers only");
     exit (-1);
     break;
    }

    case CPI_CNT_CTN:						// MD5-encoded text: perform encryption
    {
     BYTE t [1000], p [1000];


     memcpy (t,itm -> cmp [i].stg,itm -> cmp [i].len);
     cvt_b2a (t,itm -> cmp [i].len,TXF_HEX,t);					// conversion to HEX format (for log message)

     cti_enc (ctt,key,itm -> cmp [i].stg,itm -> cmp [i].len);	// interface to encryption routine

     cvt_b2a (itm -> cmp [i].stg,itm -> cmp [i].len,txf,p);		// conversion to HEX or RAW
     cpi_cmp_assign (&itm -> cmp [i],p,strlen (p),CPI_CNT_DMP); // copy result to itm->cmp[i]

     LOG (PSX_MOD_CPI,"encoding [%s]",ctt_sym);
     LOG (PSX_MOD_CPI,"key: '%s'",key);
     LOG (PSX_MOD_CPI,"src: '%s'",t);
     LOG (PSX_MOD_CPI,"dst: '%s'",p);
     break;
    }

    default:
     break;
   }
  }

 return (TRUE);
}

/******************************************************************************/
/** conversion without logging
 * @param itm pointer to cipher interface record item
 * @param enc cipher encoding information (raw or hex)
 */

static BOOL cni_itm_prc_cvt (CPI_REC_ITM * itm,CPE enc)
{
 IDX i;
 BYTE txf;

 enctotxf (enc,&txf);

 for (i = 0;i < CMP_N;i++)
  if (TEST (itm -> cnc,BIT (i)))
  {
   switch (itm -> cmp [i].cnt)
   {
    case CPI_CNT_TXT:
     break;

    case CPI_CNT_CTN:
    {
     char t [1000];

     cvt_b2a (itm -> cmp [i].stg,itm -> cmp [i].len,txf,t);
     cpi_cmp_assign (&itm -> cmp [i],t,strlen (t),CPI_CNT_DMP);
     break;
    }

    default:
     break;
   }
  }

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


