/******************************************************************************/
/* psx-cti.h                           Cryptographic Transformation Interface */
/******************************************************************************/
/** @file psx-cti.h Cryptographic Transformation Interface - Header File
 * Definitions supporting the cryptographic transformation by AES or IDEA.
 */
 
#ifndef _psx_cti_
#define _psx_cti_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

typedef BYTE CTT;
typedef BYTE * KEY;
typedef BYTE * DAT;

#define	CTT_ZERO	0x00
#define CTT_MD5		0x01
#define CTT_IDEA	0x02
#define	CTT_AES		0x03

typedef struct
{
 BOOL (* init) (void);
 BOOL (* exit) (void);
 BOOL (* enc ) (KEY k,DAT p,NUM n);
 BOOL (* dec ) (KEY k,DAT p,NUM n);
} CTI_DRV;


/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	cti_init	(void);
LINKAGE	BOOL	cti_exit	(void);
LINKAGE	BOOL	cti_enc		(CTT ctt,KEY k,DAT p,NUM n);
LINKAGE	BOOL	cti_dec		(CTT ctt,KEY k,DAT p,NUM n);

LINKAGE	BOOL	cti_ctt_enc	(CTT ctt,PSX_STR sym);
LINKAGE	BOOL	cti_ctt_dec	(CTT * ctt,PSX_STR sym);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_cti_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


