/******************************************************************************/
/* Private                                                                B2A */
/******************************************************************************/
/** @file psx-cvt-b2a.inl Conversion Interface: B2A - Inline Source Code File
 *
 * This file is based on btoa, version 4.0:
 * Stream filter to change 8 bit bytes into printable ascii
 * computes the number of bytes, and three kinds of simple checksums
 * incoming bytes are collected into 32-bit words, then printed in base 85
 *  exp(85,5) > exp(2,32)
 * the ASCII characters used are between '!' and 'u'
 * 'z' encodes 32-bit zero; 'x' is used to mark the end of encoded data.
 *
 *  Paul Rutter		Joe Orost
 *  philabs!per		petsd!joe
 *
 *  WARNING: this version is not compatible with the original as sent out
 *  on the net.  The original encoded from ' ' to 't'; which cause problems
 *  with some mailers (stripping off trailing blanks).
 *
 * note: It is assumed, that there is enough memory for the transformed
 * strings provided by the calling programme. The maximum memory needed is
 * 5*[(len+3)/4] + 1 + [log10(len) + 1] + 1 characters
 * (output + 'x' + number of characters + end of string character).
 * If the number of characters in an input strings exceeds INT_MAX, we might get
 * problems with the return value.
 */
 
typedef struct _CVT_CTX
{
 PTR   p;
 IDX   i;
 NUM   n;
 DWORD q;         /* 4 input Bytes */
 NUM   nm;
} CVT_CTX;

#define EN(c)	(int) ((c) + '!')

/******************************************************************************/
/* Private                                                      raw converter */
/******************************************************************************/
/** convert raw data
 * @param ctx pointer to conversion context 
 * @param q 4 Byte word
 */
 
static void cvt_txt_raw_enc_word (CVT_CTX * ctx,DWORD q)
{
 BYTE * p;
 int t;

 p = ctx -> p;

 if (ctx -> q == 0)
 {
  p [ctx -> n++] = 'z';
  return;
 }

 t = 0;

 if (ctx -> q < 0)
 {	/* Because some don't support unsigned long */
  t = 32;
  ctx -> q = ctx -> q - ((int) 85 * 85 * 85 * 85 * 32);
 }

 if (ctx -> q < 0)
 {
  t = 64;
  ctx -> q = ctx -> q - ((int) 85 * 85 * 85 * 85 * 32);
 }

 p [ctx -> n++] = EN ((ctx -> q / ((long) 85 * 85 * 85 * 85)) + t);
 ctx -> q %= ((int) 85 * 85 * 85 * 85);
 p [ctx -> n++] = EN (ctx -> q / ((long) 85 * 85 * 85));
 ctx -> q %= ((int) 85 * 85 * 85);
 p [ctx -> n++] = EN (ctx -> q / (85 * 85));
 ctx -> q %= (85 * 85);
 p [ctx -> n++] = EN (ctx -> q / 85);
 ctx -> q %= 85;
 p [ctx -> n++] = EN (ctx -> q);
}

/******************************************************************************/
/** encode raw data
 * @param ctx pointer to conversion context
 * @param c Byte
 */
 
static void cvt_txt_raw_enc (CVT_CTX * ctx,BYTE c)
{
 ctx -> q <<= 8;
 ctx -> q |= c;

 if (ctx -> nm == 3)
 {
  cvt_txt_raw_enc_word (ctx,ctx -> q);
  ctx -> nm = 0;
 }
 else
 {
  ctx -> nm += 1;
 }
}

/******************************************************************************/
/** manage raw data conversion
 * @param src pointer to source byte
 * @param len length of data word
 * @param dst pointer to destination string after invocation
 */
 
static BOOL cvt_txt_raw (BYTE * src,int len,char * dst)
{
 CVT_CTX ctx;
 int i;

 if (len == 0)
 {
  strcpy (dst,"");		/* no length suffix for empty strings */
  return (TRUE);
 }

 ctx.p = dst;

 ctx.n = 0;
 ctx.nm = 0;
 ctx.q = 0;

 for (i = 0;i < len;i++)
 {
  cvt_txt_raw_enc (&ctx,src [i]);
 }

 while (ctx.nm != 0)
 {
  cvt_txt_raw_enc (&ctx,0);
 }

  /* len is written as crude cross check*/

 sprintf (&dst[ctx.n],"x%d",len);
 ctx.n = strlen (dst);

 return (TRUE);
}

/******************************************************************************/
/** manage hex conversion
 * @param srco byte ointer to source string
 * @param len length of source string
 * @param dst string pointer to destination string
 */
 
static BOOL cvt_txt_hex (BYTE * src,int len,char * dst)
{
 int i;

 if (src == NULL || dst == NULL)
  return (FALSE);

 strcpy (dst,"");

 for (i = 0;i < len;i++)
 {
  PSX_STR t;

  sprintf (t,"%02X",src [i]);
  strcat (dst,t);
 }

 return (TRUE);
}


/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


