/******************************************************************************/
/* psx-cvt.c                                     Conversion Interface         */
/******************************************************************************/
/** @file psx-cvt.c Conversion Interface - Source Code File
 * Functions supporting data conversion
 */
 
#include "psx.h"

#include "psx-cvt-b2a.inl"
#include "psx-cvt-a2b.inl" // emtpy: not implemented yet

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/
/** convert HEX t RAW or RAW to HEX
 * @param src pointer to source string
 * @param len length of source string
 * @param txf textfield
 * @param dst pointer to destination string
 */

BOOL cvt_b2a (BYTE * src,int len,BYTE txf,char * dst)
{
 BOOL r = TRUE;
 char * t;

 if (src == NULL || dst == NULL)
  return (FALSE);

 if ((t = (char *) malloc ((len + 1) * sizeof (char))) == NULL)
  return (FALSE);

 memcpy (t,src,len);

 switch (txf)
 {
  case TXF_RAW:
   if (!cvt_txt_raw (t,len,dst))
    r = FALSE;
   break;

  case TXF_HEX:
   if (!cvt_txt_hex (t,len,dst))
    r = FALSE;
   break;

  default:
   r = FALSE;
 }

 free (t);

 return (r);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/





