/******************************************************************************/
/* psx-dbi.h                                               Database Interface */
/******************************************************************************/
/** @file psx-dbs.h Database Interface - Header File
 * Definitions supporting the functionalities of the Database Interface.
 */
#ifndef _psx_dbi_
#define _psx_dbi_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

typedef unsigned long int OID;

typedef struct _DBI_DRV DBI_DRV;

/** database interface
 */
 
typedef struct _DBI
{
 DBI_DRV * drv;   //*< database driver; specifies methods for data management */

 void *    tag;   //*< temporal storage of context           */

 OID        oid;  //*< object identifier */

} DBI;

/** generic struct for database drivers */
struct _DBI_DRV
{
 BOOL (* create)  (char * sym);   /**< pointer to "create" function defined in respective database driver interface */
 BOOL (* delete)  (char * sym);   /**< pointer to "delete" function */
 BOOL (* test)    (char * sym);
 BOOL (* open)    (DBI * dbi,char * dbs); /**< pointer to "open database" function */
 BOOL (* close)   (DBI * dbi);    /**< pointer to "close database" function */
 BOOL (* push)    (DBI * dbi);
 BOOL (* pop)     (DBI * dbi);
// BOOL (* get_tuples) (DBI * dbi,NUM * t);
// BOOL (* get_fields) (DBI * dbi,NUM * f);
 BOOL (* execute) (DBI * dbi,const char * sql);
 BOOL (* fetch)   (DBI * dbitypedef,IDX f,char ** v);
 BOOL (* status)  (DBI * dbi,char ** msg);
};


typedef char DBI_STR [2000];

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

LINKAGE	BOOL	dbi_create	(const char * dbs);
LINKAGE	BOOL	dbi_delete	(const char * dbs);
LINKAGE	BOOL	dbi_test	(const char * dbs);
LINKAGE	BOOL	dbi_open	(DBI ** ctx,const char * dbs);
LINKAGE	BOOL	dbi_close	(DBI ** ctx);
LINKAGE	BOOL	dbi_push	(DBI * ctx);
LINKAGE	BOOL	dbi_pop	        (DBI * ctx);

//LINKAGE	BOOL	dbi_get_tuples	(DBI * ctx, NUM * t);
//LINKAGE	BOOL	dbi_get_fields	(DBI * ctx, NUM * f);

LINKAGE	BOOL	dbi_execute	(DBI * ctx,const char * sql);
LINKAGE	BOOL	dbi_fetch	(DBI * ctx,IDX f,char ** v);

LINKAGE	BOOL	dbi_sts_print	(DBI * ctx);
LINKAGE	BOOL	dbi_idx_inc	(DBI * ctx,const char * src,const char * atr,NUM * n);
LINKAGE	BOOL	dbi_lookup	(DBI * ctx,const char * src,const char * atr,const char * cnd,char ** v);
LINKAGE	BOOL	dbi_select	(DBI * ctx,const char * src,const char * atr,const char * cnd);
LINKAGE	BOOL	dbi_insert	(DBI * ctx,const char * src,const char * atr,const char * val);
LINKAGE	BOOL	dbi_update	(DBI * ctx,const char * src,const char * cnd,const char * atr,const char * val);

LINKAGE	BOOL	dbi_val_cvt	(const char * src,char * dst);

LINKAGE	BOOL	dbi_exp_isnull	(const PSX_STR src,PSX_STR exp);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_dbi_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/



