/******************************************************************************/
/* psx-dic.h                              Dictionary Management Interface     */
/******************************************************************************/
/** @file psx-dic.h Dictionary Management Interface - Header File
 * Definitions supporting the functionality of a dictionary for storing and
 * retrieving data pairs consisting of attribute and value.
 */
 
#ifndef _psx_dic_
#define _psx_dic_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

/** dictionary item */
typedef struct _PSX_DIC_ITM
{
 IDX atr;      /**< Attribute       */
 IDX val;      /**< Value           */
} PSX_DIC_ITM;

/** dictionary */
typedef struct _PSX_DIC
{
 PSX_DIC_ITM * itm;   /**< Item             */
 NUM n;               /**< Number of Items  */
 char * stg;          /**< string           */
 NUM s;               /**< size of string   */
} PSX_DIC;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	dic_create	(PSX_DIC ** dic);
LINKAGE	BOOL	dic_delete	(PSX_DIC ** dic);
LINKAGE	BOOL	dic_clear	(PSX_DIC * dic);
LINKAGE	BOOL	dic_put		(PSX_DIC * dic,const char * atr,const char * val);
LINKAGE	BOOL	dic_get		(PSX_DIC * dic,const char * atr,char ** val);
LINKAGE	BOOL	dic_get_atr	(PSX_DIC * dic,IDX idx,char ** atr);
LINKAGE	BOOL	dic_get_val	(PSX_DIC * dic,IDX idx,char ** val);
LINKAGE	BOOL	dic_put_new	(PSX_DIC * dic,const char * atr,const char * val);
LINKAGE	BOOL	dic_copy	(PSX_DIC * dic,PSX_DIC * src);
LINKAGE	BOOL	dic_print	(PSX_DIC * dic);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_dic_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/



