/******************************************************************************/
/* psx-doc.h                                         Document Handling        */
/******************************************************************************/
/** @file psx-doc.c Document Interface - Header File
 * Defintions supporting the functionality of the Document Handling providing
 * the facility of creation of a html document.
 */
 
#ifndef _psx_doc_
#define _psx_doc_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/
/** document structure consisting of a string pointer
 */
 
typedef struct _DOC
{
 char * txt;
} PSX_DOC;

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

LINKAGE	BOOL	doc_create	(PSX_DOC ** doc);
LINKAGE	BOOL	doc_delete	(PSX_DOC ** doc);
LINKAGE	BOOL	doc_assign	(PSX_DOC * doc,char * src);
LINKAGE	BOOL	doc_load	(PSX_DOC * doc,char * pth);
LINKAGE	BOOL	doc_compile	(PSX_DOC * doc,PSX_DIC * dic);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_doc_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


