
/******************************************************************************/
/* psx-dst.h                                  Distribution Handling (for smi) */
/******************************************************************************/
/** @file psx-dst.c Distrubution Handling - Header File
 * Definitions supporting the functionalities of the Distribution Handling like
 * - Definition of type of distribution (uni, fix, relative, complex)
 * - Definition of the PSX_DST data structure
 * - Prototypes
 */

#ifndef _psx_dst_
#define _psx_dst_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

/* Distribution Type: */
#define DST_UNI 0x01 /**< use uniform distribution                 */
#define DST_FIX 0x02 /**< use a given, fixed distribution          */
#define DST_REL 0x03 /**< use relative frequencies                 */
#define DST_CMP 0x04 /**< complex distribution                     */

/* Key Type:          */
#define KEY_NO  0x00 /**< no keys                                  */
#define KEY_INT 0x01 /**< keys are array of int                    */
#define KEY_STR 0x02 /**< keys are array of char *                 */

/** Information about (Distribution)                               */
typedef struct _PSX_DST
{
 PSX_STR atr; /**< name of attribute                               */
 int dst;     /**< type of distribution (DST_...)                  */
 int n;       /**< total number of values                          */
 double * p;  /**< array of probabilities                          */
 int keytype; /**< type of keys (KEY_...)                          */
 /** keys */
 union
 {
  char ** str; /**< for KEY_STR                                    */
  int * num;   /**< for KEY_INT                                    */
 } keys;

 struct _PSX_DST * next; /**< pointer to next distribution         */
} PSX_DST;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/


LINKAGE BOOL dst_init ();
LINKAGE BOOL dst_exit ();

LINKAGE BOOL dst_get (char * atr, PSX_DST ** res);
LINKAGE BOOL dst_prob (PSX_DST * dst, char * val, double * p);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_dst_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/





