/******************************************************************************/
/* psx-fio.c                          File I/O Interface                      */
/******************************************************************************/
/** @file psx-fio.c File I/O Interface - Source Code File
 * Functions supporting file input and output:
 * - reading a line from a file
 * - calculating the size of a file
 * - printing a banner to a file
 */


#include "psx.h"

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/
/** trim string, remove whitespace character
 * @param s string
 */
 
static BOOL trim (PSX_STR s)
{
 PSX_STR t;
 char * p;
 int n;

 strcpy (t,s);
 p = t;

 while (*p != '\0' && isspace (*p))     // trim front
  p++;

 if ((n = strlen (p)) > 0)
 {
  int i = n;

  while (--i >= 0 && isspace (p [i]))   // trim back
   p [i] = 0;
 }

 strcpy (s,p);

 return (TRUE);
}

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/
/** read line from file
 * @param f input file pointer
 * @param s retrieved string
 */
  
BOOL fio_readln (FILE * f,PSX_STR s)
{
 PSX_STR t;

 if (f == NULL || s == NULL)
  return (FALSE);

 if (fgets (t,PSX_STR_MAX,f) == NULL)   // read from file
  return (FALSE);

 trim (t);                              // cut off whitespace character

 strcpy (s,t);


 return (TRUE);
}

/******************************************************************************/
/** get size of file f
 * @param f file pointer
 * @param n size of file
 */

BOOL fio_getsize (FILE * f,NUM * n)
{
 NUM pos;

 if (f == NULL || n == NULL)
  return (FALSE);

 pos = ftell (f);              // get current position in stream

 fseek (f,0,SEEK_END);         // go to end of file

 if (feof (f))
 {
  *n = 0;                      // file empty
  return (FALSE);
 }

 *n = ftell (f) + 1;           // size of file is curent position (end of file) +1

 fseek (f,pos,SEEK_SET);       // reset position

 if (feof (f))                 // pos is on end of file
 {
  *n = 0;
  return (FALSE);
 }

 return (TRUE);
}

/******************************************************************************/
/** print banner to file
 * @param f output file pointer
 * @param sym character for last element of string (boundary)
 * @param l character (left)
 * @param r character (right)
 */

BOOL fio_put_bnr (FILE * f,const char sym,const char * l,const char * r)
{
 PSX_STR s,t,u,g;
 int nl,nr,nm,xs,i;

 if (f == NULL)
  return (FALSE);

 str_gen_c (t,sym,80);        // generate String with value sym, 80 Characters

 if (l != NULL || r != NULL)
 {
  xs = 80 - 2 * 3;            // xs = 74; number of characters
  nl = l ? strlen (l) : 0;
  nr = r ? strlen (r) : 0;

  if (nl > xs)                // formatting the banner
   nl = xs;

  if (nr > xs - nl)
   nr = xs - nl;

  nm = xs - nl - nr;

  assert (nm >= 0);

  str_gen_c (s,' ',80);       // generate s, initialize with ' '
  s [0] = sym;                // add sym to front of the string
  s [1] = sym;
  s [2] = ' ';
  memcpy (s + 3,l,nl);        // append l to s
  i = 80 - 3 - nr;
  memcpy (s + i,r,nr);        // append r in the back of the string of 80 Chars
  s [78] = sym;
  s [79] = sym;               // close String with sym
 }
 else
  strcpy (s,t);

 fprintf (f,"%s\n",t);        // print to f
 fprintf (f,"%s\n",s);
 fprintf (f,"%s\n",t);

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/




