/******************************************************************************/
/* psx-fsi.h                                            File System Interface */
/******************************************************************************/
/** @file psx-fsi.c File System Interface - Header File
 * Definitions and prototypes supporting the usage of the File I/O Interface.
 */
 
#ifndef _psx_fsi_
#define _psx_fsi_

/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

SYS_STRUCTURE (SSI_FILE)
{
 FILE * f;
};

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

LINKAGE	BOOL	fil_create	(SSI_FILE ** f);
LINKAGE	BOOL	fil_delete	(SSI_FILE ** f);

LINKAGE	BOOL	fil_open	(SSI_FILE * f,char * src);
LINKAGE	BOOL	fil_close	(SSI_FILE * f);

LINKAGE	BOOL	fil_read	(SSI_FILE * f,PTR p,NUM n);
LINKAGE	BOOL	fil_write	(SSI_FILE * f,PTR p,NUM n);
LINKAGE	BOOL	fil_setpos	(SSI_FILE * f,IDX pos);
LINKAGE	BOOL	fil_getpos	(SSI_FILE * f,IDX * pos);
//LINKAGE	BOOL	fil_seek	(SSI_FILE * f,IDX idx);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_fsi_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/




