/******************************************************************************/
/* psx-fsp-psr.inl                                       Format Specification */
/******************************************************************************/
/** @file psx-fsp-psr.inl Format Specification: Parser - Inline Source Code File
 * Function implementing the parsing of a format specification line.
 */

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/

   

/******************************************************************************/
/** parse one line of format specification file
 * @param src pointer to source string
 * @param itm pointer to format item, modified by invocation
 */

static BOOL fmt_parse_itm_l (char * src,FMT_ITM * itm)
{
 #define ITM_N 9
 PSX_STR t [ITM_N],s,u;
 char * p;
 int i,k,e;

 if (src == NULL || itm == NULL)
  return (FALSE);

 i = 0;

 for (k = 0;k < ITM_N;k++)
  if (!str_tok_w (src,&i,t [k]))
   return (FALSE);

 // dtp

 strcpy (s,t [0]);

 if (!fsp_dtp_set (&itm -> dtp,s))
  return (FALSE);

 // var

 strcpy (itm -> sym,t [1]);


 // lbl

 p = t [2];

 if ((k = strlen (p)) == 0)
  return (FALSE);

 if (p [0] == '"' && p [k - 1] == '"')
  p++ [k - 1] = 0;

 strcpy (itm -> lbl,p);

 // pos

 if (sscanf (t [3],"%d",&itm -> pos) < 1)
  return (FALSE);

 // len

 if (sscanf (t [4],"%d",&itm -> len) < 1)
  return (FALSE);

 // min

 if (sscanf (t [5],"%d",&itm -> min) < 1)
  return (FALSE);

 // max

 if (sscanf (t [6],"%d",&itm -> max) < 1)
  return (FALSE);

 // tfm

 if (!fsp_tfm_dec (&itm -> tfm,t [7]))
  return (FALSE);

 // msp

 if (!fsp_equ_dec (&itm -> equ,t [8]))
  return (FALSE);

// itm -> xch = e;

 if (!fsp_tfm_enc (itm -> tfm,s))
  return (FALSE);

 if (!fsp_equ_enc (itm -> equ,u))
  return (FALSE);

 psx_put_v (">>> fmt: %s / %s / %d / %d / %d / %d / %s / %s",itm -> sym,itm -> lbl,itm -> pos,itm -> len,itm -> min,itm -> max,s,u);

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/




