/******************************************************************************/
/* psx-gui-req.inl                                   Graphical User Interface */
/******************************************************************************/
/** @file psx-gui-req.inl Graphical User Interface: Request - Inline Source Code File
 * Functions providing the execution of a request taken by the Graphical User
 * Interface.
 */
 
/******************************************************************************/
/* Private                                                                req */
/******************************************************************************/
/** check notification
 * @param ctx pointer to GUI context 
 */
 
static BOOL gui_req_notification (GUI_CTX * ctx)
{
 if (ctx -> req.rsl == IDX_NIL)
  return (FALSE);

 if (str_isnil (ctx -> sch -> rsp -> itm [ctx -> req.rsl].not))
  return (FALSE);

 return (TRUE);
}

/******************************************************************************/
/** prepare and call msi_notify
 * @param ctx pointer to GUI context
 */
 
static BOOL gui_req_notify (GUI_CTX * ctx)
{
 PSX_DIC * dic;

 if (!gui_req_notification (ctx))
  return (FALSE);

 if (!dic_create (&dic))
  return (FALSE);

 dic_copy (dic,ctx -> wui.dic);

 dic_put (dic,"MSG",ctx -> sch -> rsp -> itm [ctx -> req.rsl].not);

 msi_notify (dic);

 dic_delete (&dic);

 return (TRUE);
}

/******************************************************************************/
/** generate control number
 * @param ctx pointer to GUI context
 */
 
static BOOL gui_gen_ctn (GUI_CTX * ctx)
{
 IDX i;
 BOOL r = TRUE;

 if (ctx == NULL)
  return (FALSE);

 blk_clr (ctx -> blk);

 for (i = 0;i < ctx -> ctn -> n;i++)
 {
  PSX_STR t,s;

  rec_getLblStr (ctx -> ctn,i,s);

  strcpy (t,"");

  if (i > 0)
   strcat (t,"\n");

  strcat (t,s); // ctx -> ctn -> itm [i].atr);
  strcat (t,": ");
  strcat (t,ctx -> ctn -> itm [i].val);

  if (!blk_put_s (ctx -> blk,t))
   return (FALSE);
 }

 if (!blk_put (ctx -> blk,"",1))
  return (FALSE);

 return (TRUE);
}

/******************************************************************************/
/** put information into dictionary
 * @param ctx pointer to GUI context
 */
 
static BOOL gui_dic_put (GUI_CTX * ctx)
{
 PSX_STR t,u,v;
 IDX i;

 if (ctx == NULL)
  return (FALSE);

 if (!cgi_dic_get (ctx -> wui.dic))
  return (FALSE);

 if (!gui_gen_ctn (ctx))  // generate control number
 {
  sprintf (ctx -> msg,"Control number generation failed");

  return (FALSE);
 }

 if (!dic_put (ctx -> wui.dic,"PID",ctx -> pid))
  return (FALSE);

 if (!dic_put (ctx -> wui.dic,"CTN",ctx -> blk -> ptr))
  return (FALSE);

 if (!dic_put (ctx -> wui.dic,"MSG",ctx -> msg))
  return (FALSE);


 // fields

 for (i = 0;i < ctx -> rec -> n;i++)
 {
  PSX_STR sym,atr;

  if (strlen (ctx -> rec -> itm [i].atr) == 0)
   continue;

  strcpy (atr,ctx -> rec -> itm [i].atr);
  strup_g (atr);
  sprintf (sym,"FLD_%s",atr);

  dic_put (ctx -> wui.dic,sym,ctx -> rec -> itm [i].val);
 }

 if (gui_req_notification (ctx))
  dic_put (ctx -> wui.dic,"NOT","yes");
 else
  dic_put (ctx -> wui.dic,"NOT","no");


 return (TRUE);
}

/******************************************************************************/
/** evaluate request information
 * @param ctx pointer to GUI context
 */
 
static BOOL gui_req_evaluate (GUI_CTX * ctx)
{
 BOOL r = TRUE;

 if (ctx == NULL)
  return (FALSE);

 // psx_put ("gui_req_evaluate: ret: %d, sts: %d",ctx -> ret,ctx -> req.sts);

 if (!ctx -> ret)
 {
  if (!str_isnil (ctx -> req.msg))
   strcpy (ctx -> msg,ctx -> req.msg);
  else
   strcpy (ctx -> msg,"System Error");
  return (FALSE);	// no pid
 }

 assert (ctx -> req.rsl < ctx -> sch -> rsp -> n);
 strcpy (ctx -> msg,ctx -> sch -> rsp -> itm [ctx -> req.rsl].msg);

 if (!(ctx -> req.prm == PRM_GET || ctx -> req.prm == PRM_GEN))
  r = FALSE;

 return (r);
}

/******************************************************************************/
/** get cgi input and store in ctx.rec and ctx.sur respectively
 * @param ctx pointer to GUI context
 */
 
static BOOL gui_cgi_req_input (GUI_CTX * ctx)
{
 PSX_SCH * sch;
 PSX_FMT * fmt;
 BOOL r = TRUE,s;
 char * t;

 if (!pdi_sch_get (&sch))     // get schema
  return (FALSE);

 assert (sch != NULL);

 fmt = sch -> fsp;            // get format specification

 assert (fmt != NULL);

 // fill record rec with fields and values of fmt and wui.env
 if (!rec_fetch (ctx -> rec,fmt,ctx -> wui.env,"fld_"))
  r = FALSE;

 s = FALSE;     //default: sureness = FALSE

 if (dic_get (ctx -> wui.env,"fld_sur",&t))   // get sureness
  if (strcmp (t,"1") == 0)
   s = TRUE;

 ctx -> sur = s;

 return (r);
}

/******************************************************************************/
/** execute request
 * @param ctx pointer to GUI context
 */
 
static BOOL gui_req_execute (GUI_CTX * ctx)
{
 PSX_STR t;
 BOOL r = TRUE;
 IDX i;

 if (ctx == NULL)
  return (FALSE);

 memset (&ctx -> req,0,sizeof (ctx -> req));

 ctx -> req.rec = ctx -> rec;
 ctx -> req.ctn = ctx -> ctn;
 ctx -> req.sur = ctx -> sur;

 ctx -> ret = psi_req (&ctx -> req);     // execute request

 r = ctx -> ret;

 memcpy (ctx -> pid,ctx -> req.pid,8);
 ctx -> pid [8] = 0;

 if (!gui_req_evaluate (ctx))
  r = FALSE;

 gui_dic_put (ctx);
 return (r);
}

/******************************************************************************/
/** manage request execution process
 * @param ctx pointer to GUI context
 */

static BOOL gui_req (GUI_CTX * ctx)
{
 if (ctx == NULL)
  return (FALSE);

 switch (ctx -> wui.sts)          // web user interface status
 {
  case 0:                         // start new request
  {
   ctx -> wui.tpl = TPL_REQ;      // request template
   break;
  }

  case 1:                         // get input record, start request procedure, result notifictaion
  {
   IDX i;

   if (ctx -> wui.fmt == NULL)
    return (FALSE);

   if (!gui_cgi_req_input (ctx))  // get input record and store in ctx.rec
   {
    sprintf (ctx -> msg,"Input failed");
    return (FALSE);
   }

   ctx -> wui.tpl = TPL_RET;      // return template

   if (!gui_req_execute (ctx))    //
   {
    ctx -> wui.tpl = TPL_MSG;

    if (str_isnil (ctx -> msg))
     sprintf (ctx -> msg,"PID Request Error");

    if (!dic_put (ctx -> wui.dic,"TXT",ctx -> msg))
     ;
    if (!dic_put (ctx -> wui.dic,"MSG",ctx -> msg))
     ; //break;

    return (FALSE);
   } // end if  

   gui_req_notify (ctx);

   break;
  }  // end case 1

  default:
   return (FALSE);
 }

 return (TRUE);
}

/******************************************************************************/
/* Main                                                                       */
/******************************************************************************/
/** static BOOL prc_req(GUI_CTX * ctx): handle request
 * @param ctx pointer to GUI context
 */

static GUI_PROCEDURE (prc_req)   
{
 PSX_SCH * sch;

 if (!pdi_sch_get (&ctx -> wui.sch))   // get wui schema
  return (FALSE);

 if (!pdi_sch_get (&sch))              // get schema
  return (FALSE);

 ctx -> wui.fmt = sch -> fsp;          // get wui format specification

 gui_req (ctx);

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


