/******************************************************************************/
/* psx-gui-sys.inl                                   Graphical User Interface */
/******************************************************************************/
/** @file psx-gui-sys.inl Graphical User Interface: System - Inline Source Code File
 * Functions implementing the processing of the sys comand (ctx=sys).
 */
 
/******************************************************************************/
/*                                                                            */
/******************************************************************************/
/** get system information and put into dictionary
 * @param ctx pointer to GUI context
 */

static BOOL gui_sys_info (GUI_CTX * ctx)
{
 PDI_STS sts;
 PSX_STR t;
 PIX pix;

 ctx -> wui.tpl = TPL_SYS;
  
 if (!pdi_sts (&sts))                        /* get status */
  return (FALSE);

 sprintf (t,"%08X",sts.pix);

 if (!dic_put (ctx -> wui.dic,"PIX",t))
  return (FALSE);

 sprintf (t,"%d",sts.num_rec);

 if (!dic_put (ctx -> wui.dic,"REC",t))
  return (FALSE);

 sprintf (t,"%d",sts.num_req);

 if (!dic_put (ctx -> wui.dic,"REQ",t))
  return (FALSE);

 sprintf (t,"%d",sts.num_req_pid);

 if (!dic_put (ctx -> wui.dic,"REQ_POS",t))
  return (FALSE);

 if (!dic_put (ctx -> wui.dic,"REQ_TSP",sts.tsp_req))
  return (FALSE);

 return (TRUE); 
}

/******************************************************************************/
/** put reset message htl formatted into dictionary
 * @param ctx pointer to GUI context
 */

static BOOL gui_sys_reset (GUI_CTX * ctx)
{
 ctx -> wui.tpl = TPL_CFM;
 strcpy (ctx -> wui.tgt,"ctx=sys&sts=1");
 dic_put (ctx -> wui.dic,"TXT","<b><blink>The pseudonymization database will be erased!</blink></b><br><br><br><b>Proceed?</b>");
 return (TRUE);
}

/******************************************************************************/
/** put rest operation status into dictionary; seems to be under construction
 * @param ctx pointer to GUI context
 */

static BOOL gui_sys_reset_response (GUI_CTX * ctx)
{
 if (ctx == NULL)
  return (FALSE);
  
 switch (ctx -> wui.cmd)
 {
  case WUI_CMD_OK:
  {
   ctx -> wui.tpl = TPL_MSG;
   strcpy (ctx -> wui.tgt,"ctx=sys");
   dic_put (ctx -> wui.dic,"TXT","to be implemented...");
   break;
  }

  default:
  {
   ctx -> wui.tpl = TPL_MSG;
   strcpy (ctx -> wui.tgt,"ctx=sys");
   dic_put (ctx -> wui.dic,"TXT","Operation canceled");
   break;
  }
 }
 return (TRUE);
}

/******************************************************************************/
/** put history message into dictionary
 * @param ctx pointer to GUI context
 */
 
static BOOL gui_sys_history (GUI_CTX * ctx)
{
 char * t;

 if (!pdi_hst_get (&t))
  t = strdup ("ERROR");

 assert (t != NULL);

 ctx -> wui.tpl = TPL_MSG;
 strcpy (ctx -> wui.tgt,"ctx=sys");
 dic_put (ctx -> wui.dic,"TXT",t);
 free (t);

 return (TRUE);
}


/******************************************************************************/
/*                                                                            */
/******************************************************************************/
/** execute system GUI command
 * @param ctx pointer to GUI context
 */
 
static GUI_PROCEDURE (prc_sys)
{
 char * cmd;
 BOOL r = TRUE;

 if (ctx == NULL)
  return (FALSE);

 if (!ctx -> sys)
 {
  ctx -> wui.tpl = TPL_MSG;
  dic_put (ctx -> wui.dic,"TXT","Access denied");
  return (FALSE);
 }

 //assert (cmd != NULL);

 switch (ctx -> wui.sts)
 {
  case 0:
  {
   switch (ctx -> wui.cmd)
   {
    case WUI_CMD_RESET: r = gui_sys_reset (ctx); break;
    case WUI_CMD_HISTORY: r = gui_sys_history (ctx); break;
    default:            r = gui_sys_info (ctx); break;
   }

   break;
  }

  case 1: r = gui_sys_reset_response (ctx); break;
  
  default:
  {
   ctx -> wui.tpl = TPL_MSG;
   strcpy (ctx -> wui.tgt,"");
   dic_put (ctx -> wui.dic,"TXT","Internal error! Please send bug report!");
  }
 }

 return (r);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

