/******************************************************************************/
/* psx-gui.h                                         Graphical User Interface */
/******************************************************************************/
/** @file psx-gui.h Graphical User Interface - Header File
 * Definitions suporting the functionalities of the GUI like the GUI
 * configuration structure and the GUI context.
 */
 
#ifndef _psx_gui_
#define _psx_gui_

/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Definition                                                                 */
/******************************************************************************/
/** graphical user interface configuration                                    */
typedef struct _GUI_CFG
{
// CMI_CMD cmd;                       /**< cipher management options          */
 BOOL      sys;                       /**< enable system panel                */
 BOOL      dbg;                       /**< enable debugging                   */
} GUI_CFG;

/******************************************************************************/
/** GUI context structure                                                     */
typedef struct _GUI_CTX
{
 WUI       wui;                       /**< web user interface                 */
 PSX_REC * rec;                       /**< input record                       */
 PSX_REC * ctn;                       /**< control numbers                    */
 PSX_BLK * blk;                       /**< block                              */
 PSX_SCH * sch;                       /**< schema                             */
 PSX_STR   msg;                       /**< message                            */
 BOOL      sur;                       /**< sureness                           */
 PSI_REQ   req;                       /**< request                            */
 BOOL      ret;                       /**< request return                     */
 PSX_STR   pid;                       /**< PID                                */
 BOOL      sys;                       /**< enable system panel                */
 BOOL      dbg;                       /**< enable debugging                   */
} GUI_CTX;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	gui_create	(GUI_CTX ** ctx);
LINKAGE	BOOL	gui_delete	(GUI_CTX ** ctx);
LINKAGE	BOOL	gui_init	(GUI_CTX * ctx,GUI_CFG * cfg);
LINKAGE	BOOL	gui_exit	(GUI_CTX * ctx);
LINKAGE	BOOL	gui_run		(GUI_CTX * ctx);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_gui_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


