/******************************************************************************/
/* psx-hci.h                                 Hypertext Construction Interface */
/******************************************************************************/
/*                                                         [P] 2001 M. Wagner */
/******************************************************************************/
/** @file psx-hci.c Hypertext Construction Interface - Header File
 * Definitions and prototypes supporting the construction of html code like
 * - the definition of a Hypertext Node datatype (HTN)
 * - the definition of a Hypertext Construction Interface Context (HCI_CTX)
 * - several definitions for colour, maximum input length etc.
 */
 
#ifndef _psx_hci_
#define _psx_hci_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#define HCI_CNT	"Content-type:text/html\n\n"

/**************************************/
/** Hypertext Index
 */

typedef IDX HTX;
#define HTX_NIL IDX_NIL

/**************************************/
/** Hypertext Node
 */

typedef struct _HCI_HTN
{
 char * txt;    /**< text */
 HTX  * itm;    /**< item (tags or tags plus text?)*/
 NUM    n;      /**< number of items */
} HCI_HTN;

typedef HCI_HTN HTN;

/**************************************/
/** Hypertext Context
 */

typedef struct _HCI_CTX
{
 HCI_HTN * htn;    /**< hypertext node  */
 NUM       n;      /**< number of nodes */
} HCI_CTX;

/**************************************/
/** Color
 */

typedef DWORD HCI_CLR;

#define CLR_NIL		0x000000

#define CLR_ZERO	0x00

#define MAX_INP_SIZE "1024"

typedef HCI_CLR CLR;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

/**************************************/
/* Context Management                 */
/**************************************/

LINKAGE	BOOL	hci_create	(HCI_CTX ** ctx);
LINKAGE	BOOL	hci_delete	(HCI_CTX ** ctx);

LINKAGE	BOOL	hci_begin	(void);
LINKAGE	BOOL	hci_end		(void);

LINKAGE	BOOL	hci_put_f	(FILE * f);
LINKAGE	BOOL	hci_put_b	(PSX_BLK * blk);
LINKAGE	BOOL	hci_put_d	(PSX_DOC * doc);
LINKAGE	BOOL	hci_put		(void);

LINKAGE	BOOL	hci_dump	(void);
LINKAGE	BOOL 	hci_add		(HTX htx,HTX sub);

/**************************************/
/* Construction                       */
/**************************************/

LINKAGE	BOOL	hci_clr		(CLR clr,char * str);

LINKAGE	HTX	hci_gen		(const char * fmt,...);
LINKAGE	HTX	hci_txt		(const char * txt);
LINKAGE	HTX	hci_tag		(HTX src,const char * sym,const char * fmt,...);

LINKAGE	HTX	hci_title	(const char * txt);
LINKAGE	HTX	hci_head	(const char * ttl);
LINKAGE	HTX	hci_body	(char * bgc,char * txc,HTX src);
LINKAGE	HTX	hci_doc		(const char * ttl,HTX src);

LINKAGE	HTX	hci_a		(const char * url,const char * tgt,HTX src);
LINKAGE	HTX	hci_center	(HTX src);
LINKAGE	HTX	hci_font	(const char * f,NUM s,CLR c,HTX src);

LINKAGE	HTX	hci_table	(NUM brd,const char * xs,const char * ys,CLR bgc,const char * aln,const char * val,HTX src);
LINKAGE	HTX	hci_tr		(HTX src);
LINKAGE	HTX	hci_td		(const char * xs,const char * ys,const char * aln,const char * val,const char * csp,CLR bgc,HTX src);

LINKAGE	HTX	hci_form	(const char * act,const char * mth,HTX src);
LINKAGE	HTX	hci_input	(const char * name,const char * type,const char * val,const char * size,const char * maxsize);
LINKAGE	HTX	hci_select	(const char * name,const char * size,const char * opt);

LINKAGE	HTX	hci_textarea	(const char * name,const char * xs,const char * ys,const char * wr,BOOL ro,HTX src);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_hci_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/



