/******************************************************************************/
/* psx-hfi.h                                            Health Fund Interface */
/******************************************************************************/
/*                                                            Johannes Beigel */
/******************************************************************************/
/** @file psx-hfi.h Health Fund Interface - Header File
 * Definitons supporting the functionality of the HFI:
 * - Definition of an enumeration datatype covering all supported health
 * insurance organisations
 * - Definition of an enumeration datatype for health fund validation (HIV)
 * - Prototypes providing the functionality to all other modules
 */


#ifndef _psx_hfi_
#define _psx_hfi_

/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Codes                                                                      */
/******************************************************************************/

/**************************************/
/* Health Insurance Organization      */
/**************************************/

typedef enum KRKenum
{
 HIO_AOK    =  1,
 HIO_BARMER =  2,
 HIO_DAK    =  3,
 HIO_GAE    =  4,
 HIO_GEK    =  5,
 HIO_HMK    =  6,
 HIO_HEK    =  7,
 HIO_HKK    =  8,
 HIO_NEP    =  9,
 HIO_KEH    = 10,
 HIO_TKK    = 11,
 HIO_BKK    = 12,
 HIO_IKKUC  = 13,
 HIO_IS_KV  = 14,
 HIO_KKH    = 15,
 HIO_BRU    = 16,
 HIO_BUC    = 17,
 HIO_BKN    = 18,
 HIO_LAK    = 19,
 HIO_SEK    = 20,
 HIO_IKK    = 21,
 HIO_OTHER
} HIO;

typedef HIO KRK;

/**************************************/
/* Health Insurance Code              */
/**************************************/

typedef PSX_STR HIC;

/* Health Insurance Code -Check: */

/**************************************/
/** Health Insurance Validation        */
/**************************************/

typedef enum _HIV
{
 HIV_OK      = 1,
 HIV_ERROR   = 2,
 HIV_UNKNOWN = 3
} HIV;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	hfi_hio_enc	(HIO hio,PSX_STR sym);
LINKAGE	BOOL	hfi_hio_dec	(HIO * hio,PSX_STR sym);
LINKAGE	BOOL	hfi_hio_lst_hml	(PSX_STR opt);

/* hif_check(): Check Function for KVN (hic)

   Parameter:
   - hio:  to which health insurance organisation belongs KVN
   - hic:  KVN as String
   - hiv:  pointer to variable of type HIV, contains result after invocation

   Return Value:
   - TRUE:  Check done (hiv contains result)
   - FALSE: Check failed (e.g. not known KRK (hio) or KVN is no number)
*/
LINKAGE	BOOL	hfi_check	(HIO hio,HIC hic,HIV * hiv);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_hfi_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

