/******************************************************************************/
/* psx-lst.h                                     List Interface               */
/******************************************************************************/
/** @file psx-lst.h List Interface - Header File
 * Definitions supporting the functionality of a concatenated list. The List
 * is implemented as a structure containing head and tail pointer, an additional
 * seek pointer for better search. 
 */
  
#ifndef _psx_lst_
#define _psx_lst_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#define LST_POS_HEAD (IDX_NIL - 4)
#define LST_POS_TAIL (IDX_NIL - 3)
#define LST_POS_PRED (IDX_NIL - 2)
#define LST_POS_SUCC (IDX_NIL - 1)

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

SYS_STRUCTURE (SSI_LST)
{
 PTR h;        /* head */
 PTR t;        /* tail */
 PTR s;        /* seek */
};

typedef SSI_LST * LST;

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

LINKAGE	BOOL	lst_create	(SSI_LST ** l);
LINKAGE	BOOL	lst_delete	(SSI_LST ** l);

LINKAGE	BOOL	lst_clear	(SSI_LST * l);
LINKAGE	BOOL	lst_free	(SSI_LST * l);

LINKAGE	BOOL	lst_put		(SSI_LST * l,PTR p);

LINKAGE	BOOL	lst_seek	(SSI_LST * l,IDX pos);
LINKAGE	BOOL	lst_get		(SSI_LST * l,IDX pos,PTR p);

LINKAGE	BOOL	lst_cnt		(SSI_LST * l,NUM * n);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_lst_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


