/******************************************************************************/
/* psx-msi.h                                            Mail System Interface */
/******************************************************************************/
/** @file psx-msi.h Mail System Interface - Header File
 * Definitions providing a Mailing System being able to send a notification mail
 * to the administrator:
 * - Mailing Instance
 * - Mail Configuration
 * - Prototypes providing the functionality to other modules
 */
 
#ifndef _psx_msi_
#define _psx_msi_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Definition                                                                 */
/******************************************************************************/

/**************************************/
/** Mail Instance                     */
/**************************************/

typedef struct _MSI_INS
{
 PSX_STR   name;                        /**< name                   */
 PSX_STR   adr;                         /**< address                */
} MSI_INS;

/**************************************/
/** Mail Configuration                */
/**************************************/

typedef struct _MSI_CTX
{
 MSI_INS   snd;                         /**< send                    */
 MSI_INS   rec;                         /**< receive                 */
 PSX_STR   sub;                         /**< subject                 */
 PSX_BLK * txt;                         /**< text                    */
} MSI_CTX;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	msi_create	(MSI_CTX ** ctx);
LINKAGE	BOOL	msi_delete	(MSI_CTX ** ctx);

LINKAGE	BOOL	msi_set_snd	(MSI_CTX * ctx,MSI_INS * ins);
LINKAGE	BOOL	msi_set_rec	(MSI_CTX * ctx,MSI_INS * ins);
LINKAGE	BOOL	msi_set_sub	(MSI_CTX * ctx,PSX_STR txt);
LINKAGE	BOOL	msi_put		(MSI_CTX * ctx,const char * fmt,...);
LINKAGE	BOOL	msi_send	(MSI_CTX * ctx);

LINKAGE	BOOL	msi_notify	(PSX_DIC * dic);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_msi_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


