/******************************************************************************/
/* psx-mti-mpr.inl                                       Matching Interpreter */
/******************************************************************************/
/** @file psx-mti-mpr.inl Matching Interface: Interpreter - Inline Source Code File
 * Functions implementing the whole KSXO matching process. The matching starts
 * within mti_run. 
 */

/******************************************************************************/
/** status - process epilogue: specifiy target
 * @param ctx pointer to matching context
 * @param tgt pointer to PSP_TGT pointer, target after invocation
 */

static BOOL mti_sts_prc_epi (CTX_MAT * ctx,PSP_TGT ** tgt)
{
 assert (ctx != NULL);
 assert (tgt != NULL);

 switch (ctx -> mtr)           // check match result
 {
  case MTR_X0: *tgt = &ctx -> sch -> psp -> itm [ctx -> sts].epi.tgt_0; break;
  case MTR_X1: *tgt = &ctx -> sch -> psp -> itm [ctx -> sts].epi.tgt_1; break;
  case MTR_G1: *tgt = &ctx -> sch -> psp -> itm [ctx -> sts].epi.tgt_m; break;
  default:     *tgt = NULL;  return (FALSE);
 }

 return (TRUE);
}

/******************************************************************************/
/** status - process input state: set mtr
 * @param ctx pointer to context structure
 */

static BOOL mti_sts_prc_i (CTX_MAT * ctx)
{
 assert (ctx != NULL);
 assert (ctx -> sch -> psp -> itm [ctx -> sts].pro.stt == STT_INPUT);

 if (ctx -> req -> sur)       // check sureness
  ctx -> mtr = MTR_X1;
 else
  ctx -> mtr = MTR_X0;

 return (TRUE);
}

/******************************************************************************/
/** status - process query state
 * @param ctx pointer to matching context
 */

static BOOL mti_sts_prc_q (CTX_MAT * ctx)
{
 PSX_STR t;

 assert (ctx != NULL);
 assert (ctx -> sch -> psp -> itm [ctx -> sts].pro.stt == STT_QUERY);

 /* encode match mode (KSXO) into string for log file output */
 mti_mtm_enc (ctx -> sch -> psp -> itm [ctx -> sts].pro.mtm,t);
 LOG (MOD,"> query: %s",t);

 ctx -> mtr = ctx -> sel (ctx,ctx -> sch -> psp -> itm [ctx -> sts].pro.mtm);

 return (TRUE);
}

/******************************************************************************/
/** status - process state
 * @param ctx pointer to matching context
 */

static BOOL mti_sts_prc (CTX_MAT * ctx)
{
 PSX_STR s;
 PSP_TGT * tgt;

 LOG (MOD,"processing state: %s",ctx -> sch -> psp -> itm [ctx -> sts].sym);

 /* check if current state is input state or query state 
  * (requires different handling)
  */
 switch (ctx -> sch -> psp -> itm [ctx -> sts].pro.stt)
 {
  case STT_INPUT:     //stt: status type
   LOG (MOD,"> type: input state");
   if (!mti_sts_prc_i (ctx))
   {    
    ctx -> run = FALSE;
    return (FALSE);
   }   
   break;

  case STT_QUERY:
   LOG (MOD,"> type: query state");
   if (!mti_sts_prc_q (ctx))
   {    
    ctx -> run = FALSE;
    return (FALSE);
   }   
   break;

  default:
   LOG (MOD,"> type: illegal state");
   ctx -> run = FALSE;
   return (FALSE);
 }

 mti_mtr_get (ctx -> mtr,s);
 LOG (MOD,"> result: %s",s);

/* process epilogue to get target state */
 if (!mti_sts_prc_epi (ctx,&tgt))
 {
  LOG (MOD,"> illegal target state");
  ctx -> run = FALSE;
  return (FALSE);
 }

 assert (tgt != NULL);

 /* check type of target: query state or result */
 switch (tgt -> sdt)
 {
  case SDT_STS:									// another query state
   assert (tgt -> idx < ctx -> sch -> psp -> n);
   LOG (MOD,"> target: S: %s",ctx -> sch -> psp -> itm [tgt -> idx].sym);
   break;

  case SDT_RSL:
   assert (tgt -> idx < ctx -> sch -> rsp -> n); // result is reached
   LOG (MOD,"> target: R: %s",ctx -> sch -> rsp -> itm [tgt -> idx].sym);   
   ctx -> rsl = tgt -> idx;						 // set result to target
   ctx -> run = FALSE;
   return (TRUE);

  default:
   LOG (MOD,"> illegal target state type");
   ctx -> run = FALSE;
   return (FALSE);
 }

 /* target state becomes current state */
 ctx -> sts = tgt -> idx;

 return (TRUE);
}

/******************************************************************************/
/* Main                                                                       */
/******************************************************************************/
/** run matching
 * @param ctx pointer to matching context
 */
 
static BOOL mti_run (CTX_MAT * ctx)
{
 if (ctx == NULL)
  return (FALSE);

 LOG (MOD,"-> matching start");

 ctx -> sts = 0;
 ctx -> rsl = IDX_NIL;
 ctx -> run = TRUE;

 while (ctx -> run)
  mti_sts_prc (ctx);

 LOG (MOD,"-> matching stop");

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


