/******************************************************************************/
/* psx-mti.c                                               Matching Interface */
/******************************************************************************/
/** @file psx-mti.c Matching Interface - Source Code File
 * Functions preparing and starting the matching process, this file also
 * implements the handling of the matching result and the conversion of the KSXO
 * notation into string. 
 */
 
#include "psx.h"


/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/

#define	MOD	PSX_MOD_MTI

#include "psx-mti.inl"

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/
/** encode KSXO into string
 * @param mtm match mode (MTM_K1, MTM_S0, MTM_S1, MTM_X0, MTM_XI or MTM_O1)
 * @param sym result string after invocation
 */

BOOL mti_mtm_enc (MTM mtm,PSX_STR sym)
{
 PSX_STR k,s,x,o;

 if (sym == NULL)
  return (FALSE);

 if (TEST (mtm,MTM_K1))
  strcpy (k,"1");
 else
  strcpy (k,"0");

 if (TEST (mtm,MTM_S0))
  if (TEST (mtm,MTM_S1))
   strcpy (s,"*");
  else
   strcpy (s,"0");
 else
  if (TEST (mtm,MTM_S1))
   strcpy (s,"1");
  else
   strcpy (s,"?");

 if (TEST (mtm,MTM_X0))
  strcpy (x,"0");
 else
  if (TEST (mtm,MTM_X1))
   strcpy (x,"1");
  else
   if (TEST (mtm,MTM_XI))
    strcpy (x,"-");
   else
    strcpy (x,"?");

 if (TEST (mtm,MTM_O1))
  strcpy (o,"1");
 else
  strcpy (o,"0");

 sprintf (sym,"K%s:S%s:X%s:O%s",k,s,x,o);

 return (TRUE);
}

/******************************************************************************/
/** KSXO decoding
 * @param mtm matchmode after invocation
 * @param sym input symbol string of matchmode
 */
 
BOOL mti_mtm_dec (MTM * mtm,PSX_STR sym)
{
 PSX_STR t;
 int i;

 if (mtm == NULL || sym == NULL)
  return (FALSE);

 *mtm = MTM_ZERO;

 i = 0;

 while (str_tok (sym,&i,":",t))
  if (strcmp (t,"K0") == 0)		*mtm |= MTM_K0;
  else
   if (strcmp (t,"K1") == 0)		*mtm |= MTM_K1;
   else
    if (strcmp (t,"S0") == 0)		*mtm |= MTM_S0;
    else
     if (strcmp (t,"S1") == 0)		*mtm |= MTM_S1;
     else
      if (strcmp (t,"S*") == 0)		*mtm |= MTM_SX;
      else
       if (strcmp (t,"X0") == 0)	*mtm |= MTM_X0;
       else
        if (strcmp (t,"X1") == 0)	*mtm |= MTM_X1;
        else
         if (strcmp (t,"X-") == 0)	*mtm |= MTM_XI;
         else
          if (strcmp (t,"O0") == 0)	*mtm |= MTM_O0;
          else
           if (strcmp (t,"O1") == 0)	*mtm |= MTM_O1;
          else
           return (FALSE);

 return (TRUE);
}

/******************************************************************************/
/** decode result of matching into string
 * @param mtr result of matching
 * @param str result string after invocation
 */

BOOL mti_mtr_get (BYTE mtr,PSX_STR str)
{
 switch (mtr)
 {
  case MTR_X0: strcpy (str,"0");  break;  // 0x01
  case MTR_X1: strcpy (str,"1");  break;  // 0x02
  case MTR_G1: strcpy (str,">1"); break;  // 0x03
  default:     strcpy (str,"?");  return (FALSE);
 }

 return (TRUE);
}

/******************************************************************************/
/** main entry point for expression generator
 * @param sch pointer to schema structure
 * @param rec pointer to record structure
 * @param mtm matchmode
 * @param exp pointer to PSX_EXP pointer
 */

BOOL mti_exp_gen (PSX_SCH * sch,PSX_REC * rec,MTM mtm,PSX_EXP ** exp)
{
 MTI_CTX_EXP ctx;
 PSX_STR t;

 if (sch == NULL || rec == NULL || exp == NULL)
  return (FALSE);

 //mti_mtm_enc (mtm,t); //result t is never used!

 ctx.sch = sch;              // schema
 ctx.rec = rec;              // record
 ctx.exp = exp;              // expression
 ctx.mtm = mtm;              // matchmode

 if (!mti_exp_gen_run (&ctx))            // run expression generation
  return (FALSE);

 return (TRUE);
}

/******************************************************************************/

//extern int exp_sem;
/** generate sql (condition) expression depending on match mode mtm and store in sql
 * @param sch pointer to schema
 * @param rec pointer to record
 * @param mtm matchmode
 * @param pointer to sql statement string pointer
 */

BOOL mti_exp_gen_sql (PSX_SCH * sch,PSX_REC * rec,MTM mtm,char ** sql)
{
 PSX_EXP * e;

 if (sch == NULL || rec == NULL || sql == NULL)
  return (FALSE);

 if (!mti_exp_gen (sch,rec,mtm,&e))         // generate expression
  return (FALSE);
 
 if (!exp_format (e,EFS_SQL,sql))           // format expression
 {
  exp_delete (&e);
  return (FALSE);
 }

 exp_delete (&e);

 return (TRUE);
}

/******************************************************************************/
/** print expression
 * @param sch pointer to schema
 * @param mtm matchmode
 */
 
BOOL mti_print (PSX_SCH * sch,MTM mtm)
{
 PSX_REC * r;
 PSX_EXP * e;
 char * sql;
 PSX_STR t;

 if (sch == NULL)
  return (FALSE);

 if (!rec_create (&r))
  return (FALSE);

 if (sch_rec_dummy (sch,r))      // BG: then what? 
  ;//rec_print (r);

 mti_mtm_enc (mtm,t);                      // encode matchmode into string
 psx_put ("mti Documentation [%s]\n",t);

 if (!mti_exp_gen (sch,r,mtm,&e))          // generate expression
 {
  rec_delete (&r);
  psx_put ("error (mtm=%02XH)",mtm);
  return (FALSE);
 }

 exp_print (e,EFS_IND|EFS_CMT);            // print expression

 printf ("\nSQL:\n\n");
 exp_print (e,EFS_SQL|EFS_IND);            // print sql expression
 printf ("\n\n");

 if (e)
  exp_delete (&e);

 rec_delete (&r);

 return (TRUE);
}

/******************************************************************************/
/** execute mti_run
 * @param ctx pointer to matcing context
 */
#include "psx-mti-mpr.inl"  // has to know the functions above

BOOL mti_execute (CTX_MAT * ctx)
{
 if (ctx == NULL)
  return (FALSE);

 if (!mti_run (ctx))
  return (FALSE);

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


