/******************************************************************************/
/* psx-mti.h                                               Matching Interface */
/******************************************************************************/
/** @file psx-mti.h Matching Interface - Header File
 * Definitions and prototypes supporting the creation of expressions for the
 * WHERE clause of a SQL statement during the matching process.
 * Definitions:
 * - Match Result in BYTE representation
 * - Matching Context Structure
 * - Prototypes
 */
 
#ifndef _psx_mti_
#define _psx_mti_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"


/**************************************/
/* Match Mode                         */
/**************************************/

// typedef BYTE MTM; // -> sch


/**************************************/
/* Match Result                       */
/**************************************/

#define	MTR_ZERO	0x00
#define	MTR_X0		0x01      /**< exactly zero      */
#define	MTR_X1		0x02      /**< exactly one       */
#define	MTR_G1		0x03      /**< greater than one  */

/**************************************/
/* Matching Context                   */
/**************************************/

typedef struct _CTX_MAT CTX_MAT;
/** matching context                  */
struct _CTX_MAT
{
 PDI_REQ * req;                           /**< request                          */
 PSX_SCH * sch;                           /**< schema                           */
 PSX_REC * rec;                           /**< record                           */
 char    * cnd;                           /**< condition                        */
 PSX_STR   pid;                           /**< pid                              */
 char    * sql;                           /**< select expression                */
 BOOL      mrs;                           /**< matched record sureness          */
 BOOL      run;                           /**< matching loop condition          */
 BYTE      mtr;                           /**< match result of one state.
										       Takes as value one of MTR_X0, MTR_X1,
											   MTR_G1	                        */
 IDX       sts;                           /**< matching status index            */
 IDX       rsl;                           /**< matching result index.
										       Holds index of corresponding result
											   in structure pdi.sch -> rsp -> itm   */
 BYTE   (* sel) (CTX_MAT * ctx,BYTE mtm); /**< pointer to function              */
};

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

/**************************************/
/* syn: encode/decode match mode      */

LINKAGE	BOOL	mti_mtm_enc	(MTM mtm,PSX_STR sym);
LINKAGE	BOOL	mti_mtm_dec	(MTM * mtm,PSX_STR sym);

LINKAGE	BOOL	mti_mtr_get	(BYTE mtr,PSX_STR str);

/**************************************/
/* syn: generate expression           */
/*      sch: schema                   */
/*      rec: record                   */
/*      mxs: match expression style   */
/*      exp: target expression        */

LINKAGE	BOOL	mti_exp_gen	(PSX_SCH * sch,PSX_REC * rec,MTM mtm,PSX_EXP ** exp);

/**************************************/
/* syn: generate expression, SQL mode */

LINKAGE	BOOL	mti_exp_gen_sql	(PSX_SCH * sch,PSX_REC * rec,MTM mtm,char ** sql);

LINKAGE	BOOL	mti_print	(PSX_SCH * sch,MTM mtm);

LINKAGE	BOOL	mti_execute	(CTX_MAT * ctx);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_mti_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


