/******************************************************************************/
/* psx-nci.c                         Network Connectivity Interface           */
/******************************************************************************/
/** @file psx-nci.c Network Conenectivity Interface - Source Code File
 * Functions supporting the Network Connectivity like the handling of an IP
 * address.
 */

#include "psx.h"

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/
/** parse and split ip address
 * @param s whole ip address 
 * @param a ip address splitted in its four parts
 */

static BOOL nci_adr_parse (char * s,BYTE a [4])
{
 NUM n [4];
 int i,k;

 if (s == NULL || a == NULL)
  return (FALSE);

 k = sscanf (s,"%u.%u.%u.%u",&(n[0]),&(n[1]),&(n[2]),&(n[3]));

 for (i = 0;i < 4;i++)
  if (n [i] > 255)                // not valid
   return (FALSE);

 for (i = 0;i < 4;i++)
  a [i] = (BYTE) n [i];           // cast value to byte and store in a

 return (TRUE);
}


/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/
/** lookup host by address
 * @param adr ip address as string
 * @param host host name
 */

BOOL nci_lookup (PSX_STR adr,PSX_STR host)
{
 int i;
 char c [4];
 BYTE b [4];
 struct hostent * h;

 if (adr == NULL || host == NULL)
  return (FALSE);

 if (!nci_adr_parse (adr,b))
  return (FALSE);

 for (i = 0;i < 4;i++)
  c [i] = (char) b [i];

 if ((h = gethostbyaddr (c,4,AF_INET)) == NULL)
  return (FALSE);

 //printf ("r: %d: %s\n",h_errno,hstrerror (h_errno));
 if (str_isnil (h -> h_name))
  return (FALSE);

 strcpy (host,h -> h_name);

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/



