/******************************************************************************/
/* psx-pdi.h                              Pseudonymization Database Interface */
/******************************************************************************/
/** @file psx-pdi.h PID Database Interface - Header File
 * Definitions and prototypes supporting the PID handling and generation.
 * - PID datatype
 * - PDI configuration structure (PDI_CFG)
 * - PDI request structure (PDI_REQ)
 * - PDI status structure (PDI_STS)
 * - Prototypes
 */
 
#ifndef _psx_pdi_
#define _psx_pdi_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

/**************************************/
/* PID                                */
/**************************************/

typedef IDX PIX;

/** pseudonymisation identifier */
typedef char PID [9];

/**************************************/
/* Configuration                      */
/**************************************/
/** PDI configuration structure       */

typedef struct _PDI_CFG
{
 int k1;                 /**< encryption key 1 */
 int k2;                 /**< encryption key 2 */
 int k3;                 /**< encryption key 3 */
 int rw;                 /**< key randwidth    */
} PDI_CFG;

/**************************************/
/* Request                            */
/**************************************/
/** PDI request structure             */

typedef struct _PDI_REQ
{
 /* input */

 PSX_REC * rec;                       /**< input record                       */
 PSX_REC * hsr;                       /**< history record                     */
 BOOL      sur;                       /**< input sureness                     */
 BOOL      frc;                       /**< force                              */

 /* output */

 PID       pid;                       /**< PID                                */
 PIX       pix;                       /**< PIX                                */
 // JM:
 PSX_REC * rec_old;					  /**< matched record			          */ //JM: Ende
 BOOL      mrs;	                      /**< matched record sureness            */
 PRM       prm;	                      /**< pid retrieval mode                 */ 
 IDX       rsl;                       /**< result                             */
} PDI_REQ;

/**************************************/
/* Status                             */
/**************************************/
/** PDI status structure              */

typedef struct _PDI_STS
{
 PIX     pix;
 NUM     num_rec;                     /**< number of records                  */
 NUM     num_req;                     /**< number of requests                 */
 NUM     num_req_pid;                 /**< number of requests returning pid   */
 PSX_STR tsp_req;                     /**< request timestamp                  */
} PDI_STS;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	pdi_cfg		(PDI_CFG * cfg);
LINKAGE	BOOL	pdi_create	(void);
LINKAGE	BOOL	pdi_delete	(void);
LINKAGE	BOOL	pdi_open	(void);
LINKAGE	BOOL	pdi_close	(void);
LINKAGE	BOOL	pdi_register	(PSX_SCH * sch);
LINKAGE	BOOL	pdi_sch_get	(PSX_SCH ** sch);
LINKAGE	BOOL	pdi_req_get	(PSX_STR tsp);
LINKAGE	BOOL	pdi_fmt_get	(PSX_FMT * fmt);
LINKAGE	BOOL	pdi_pix_get	(PIX * pix);
LINKAGE	BOOL	pdi_pix_set	(PIX pix);
LINKAGE	BOOL	pdi_pid_make	(PID pid,PIX pix);
LINKAGE	BOOL	pdi_lookup	(PSX_REC * rec,PSX_STR pid);
LINKAGE	BOOL	pdi_gen		(PDI_REQ * req);
LINKAGE	BOOL	pdi_req		(PDI_REQ * req);
LINKAGE	BOOL	pdi_sts		(PDI_STS * sts);
LINKAGE	BOOL	pdi_hst_get	(char ** h);
LINKAGE	BOOL	pdi_get_dbi	(DBI ** dbi);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_pdi_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


