/******************************************************************************/
/* psx-pgi.h                                         PID Generation Interface */
/******************************************************************************/
/** @file psx-pgi.h PID Generation Interface - Header File     
 * Functions to support a pseudonymization service            
 *   PID = Pseudonymous IDentificator                         
 *                                                            
 * 1. Generate a PID from a current number: PIDgen            
 *      The correspondence between ID data (or current        
 *      number) and PID has to be stored elsewhere.           
 *                                                            
 * 2. Check a given PID for validity:       PIDcheck          
 *      The algorithm recognizes up to 2 errors in the PID    
 *      and corrects one error or a transposition of adjacent 
 *      characters.                                           
 *
 * The encryption keys k1, k2, k3 and the number rndwidth of  
 *   bits for randomization (global variables) must be set
 *   before applying PIDgen.                                  
 * Important note: The keys should be different for different 
 *   application contexts; otherwise the pseudonymous         
 *   property of the PID is weakened.                         
 *
 * Klaus Pommerening, IMSD, Johannes-Gutenberg-Universitaet,  
 *   Mainz, 3. April 2001                                     
 * Version 1.00, 29. Mai 2004                                 
 */


/******************************************************************************/

#ifndef _psx_pgi_
#define _psx_pgi_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"


typedef unsigned long UINT30;       /**< 30-bit-integers >= 0 */

UINT30 k1, k2, k3;            /**< encryption keys            */
unsigned rndwidth;            /**< bits for randomization     */

  /************************************************************/
  /* A nonnegative integer of up to (30-rndwidth) bits gets   *
   *   randomized by prefixing it with rndwidth random bits.  *
   *                                                          *
   *      | random part |  number      |                      *
   * Bits: 29   ...    k  k-1   ...   0                       *
   *      |< rndwidth  >|              |                      *
   *                   1   0    ...   0  = rndfact = 2^k      *
   *----------------------------------------------------------*
   * Constraints:  0 <= rndwith <= 12.                        *
   * rndwidth = 0 implies *no randomization*.                 *
   ************************************************************/

char *PIDgen(UINT30 x);
int PIDcheck(char *p, char *a);
 
  

#endif // _psx_pgi

