/******************************************************************************/
/* psx-pho-c.h                                  Phonetics Interface - Cologne */
/******************************************************************************/
/** @file psx-pho-c.h Phonetics Interface: Cologne - Header File
 * Definionsand prototypes supporting the phonetic transformation according to
 * the Cologne Method.
 * Authors:
 * - Michael Pollecker (1992)                                                   
 * - Irene Schmidtmann (1993)                                                   
 * - Markus Wagner (2000)  
 */

/******************************************************************************/

#ifndef _psx_pho_p_
#define _psx_pho_p_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/
 
#define KOELN          1 
#define SOUND          2  
 
char * phon_code (char * str,int len,int flag);

    /* KOELN for cologne phonetic, 
       SOUND for modified cologne phonetic */ 
char *strup_g (char *str); 
char *cleanstr_g (char *src); 



/******************************************************************************/
/*                                                                            */
/******************************************************************************/

LINKAGE	BOOL	pho_col		(char * txt);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_pho_p_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


