/******************************************************************************/
/* psx-pho.c                               Phonetics Interface                */
/******************************************************************************/
/** @file psx-pho.c Phonetics Interface - Source Code File
 * Function supporting the phonetic transformation of records according to the
 * Cologne Method and the Hanover Method.
 */
 
#include "psx.h"

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/
/** genereate phonetic code
 * @param txt pointer to string source
 * @param pho phonetic string
 */
 
BOOL pho (char * txt,BYTE pho)
{
 if (txt == NULL)
  return (FALSE);
//printf ("pho[%d]:'%s' ",pho,txt);
 if (strcmp (txt,"") == 0)
  return (FALSE);

 switch (pho)
 {
  case PHO_COL:
   if (!pho_col (txt))                      // cologne
    return (FALSE);
   break;

  case PHO_HAN:
   if (!pho_han (txt))                      // hanover
    return (FALSE);
   break;

  default:
   return (FALSE);
 }

//printf ("-> '%s'\n",txt);

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/



