/******************************************************************************/
/* psx-pho.h                                  Phonetics Interface             */
/******************************************************************************/
/** @file psx-pho.h Phonetics Interface - Header File
 * Definitions and prototypes supporting the phonetic transformation of data into
 * phonetic codes.
 */
 
#ifndef _psx_pho_
#define _psx_pho_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Definition                                                                 */
/******************************************************************************/
/** phonetic code */
#define PHO_ZERO	0x00
#define PHO_COL		0x01	/**< Cologne */
#define PHO_HAN		0x02	/**< Hannover */

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	pho		(char * txt,BYTE pho);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_pho_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


