/******************************************************************************/
/* psx-pmi.h                                         PID Management Interface */
/******************************************************************************/
/** @file psx-pmi.h PID Management Interface  - Header File
 * Definitions supporting the PID Management Interface in its functionality.
 * - Definition of the PID Management configuration structure (PMI_CFG)
 * - Definition of the PID Management Context structure (PMI_CTX, PSX_PMX)
 * - Prototypes 
 */
 
#ifndef _psx_pmi_
#define _psx_pmi_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

typedef BYTE PMI_CMD;

#define	PMI_CMD_ZERO	0x00
#define	PMI_CMD_REQ	0x01

/** PID Management configuration structure                                    */
typedef struct _PMI_CFG
{
 PMI_CMD   cmd;                       /**< command                            */
 char *    iff;                       /**< input format file                  */
 char *    idf;                       /**< input data file                    */
 char *    odf;                       /**< output data file                   */
 char *    otf;                       /**< output trace file                  */

 BOOL      bat;                       /**< batch mode                         */
 NUM       pos;                       /**< start position                     */
 int       sur;                       /**< sureness                           */
 BOOL      frc;                       /**< force                              */
 ICS       ics;                       /**< input character set				  */
 PSX_STR del;                  /**< :BG: record input delimiter */ 
} PMI_CFG;

/******************************************************************************/
/** PID Management Interface context structure                                */
typedef struct _PMI_CTX
{
 CMI_CMD   cmd;                       /**< cipher management options          */

 PSX_FSP * ifs;                       /**< input format specification         */


 FILE *    ids;                       /**< input data stream                  */
 FILE *    ots;                       /**< output trace stream                */

 PSX_REC * idr;                       /**< input data record                  */
 PSX_REC * odr;                       /**< output data record                 */
 PSX_REC * cnr;                       /**< control number record              */

 PSX_SCH * sch;                       /**< schema                             */
 int       sur;                       /**< input record sureness              */

 BOOL      bat;                       /**< batch mode                         */
 BOOL      frc;                       /**< force generation                   */
 NUM       pos;                       /**< start position                     */
 IDX       rsl;                       /**< result index                       */
 ICS       ics;                       /**< input character set				  */
 PSX_STR del;                   /**< :BG: delimiter for csv input */
 TMI_TMG   tmg;                       /**< timing                             */

 PSX_STR msg;                         /**< user output message                */

} PMI_CTX;

typedef PMI_CTX PSX_PMX;


/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	pmi_create	(PMI_CTX ** ctx);
LINKAGE	BOOL	pmi_delete	(PMI_CTX ** ctx);

LINKAGE	BOOL	pmi_init	(PMI_CTX * ctx,PMI_CFG * cfg);
LINKAGE	BOOL	pmi_exit	(PMI_CTX * ctx);

LINKAGE	BOOL	pmi_run		(PMI_CTX * ctx);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_pmi_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

