/******************************************************************************/
/* psx-psi.h                               Pseudonymization Service Interface */
/******************************************************************************/
/** @file psx-psi.h Pseudonymization Service Interface - Header File
 * Definitions supporting the Pseudonymization Service Interface
 * - Defintition of PSI Status Codeword
 * - PSI Request Structure (PSI_REQ)
 * - Prototypes
 */
 
#ifndef _psx_psi_
#define _psx_psi_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Definition                                                                 */
/******************************************************************************/

/**************************************/
/* Status                             */
/**************************************/

#define PSI_STS_ZERO        0x00
#define PSI_STS_INCOMPLETE  0x01  /**< status incomplete  */
#define PSI_STS_NAMELENGTH  0x02  /**< status namelength  */
#define PSI_STS_INVALID     0x03  /**< status invalid     */

/**************************************/
/* Request                            */
/**************************************/

/** PSI request structure             */
typedef struct _PSI_REQ
{
 /* input */

 PSX_REC * rec;                         /**< input record                       */
 BOOL      sur;                         /**< input record sureness              */
 //ICS       ics;                         /**< input character set              */

 /* output */

 PSX_REC * ctn;                         /**< control number record              */

 PID       pid;                         /**< pseudomisation idetificator        */
 PIX       pix;                         /**< PID index                          */
 BYTE      mat;                         /**< match                              */
 BYTE      sts;                         /**< status                             */
 PSX_STR   msg;                         /**< message                            */
 BOOL      frc;                         /**< force generation                   */
 PRM       prm;                         /**< PID retrieval mode                 */
 IDX       rsl;                         /**< result index                       */
} PSI_REQ;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE BOOL psi_req      (PSI_REQ * req);
LINKAGE BOOL psi_get_str  (PID pid,PSX_STR str);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_psi_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/




