/******************************************************************************/
/* psx-psp.c                          Procedure Specification                 */
/******************************************************************************/
/** @file psx-psp.c Procedure Specification - Source Code File
 * This module provides the creation and modification of a procedure
 * specification structure.
 * - creation and deletion of an PSP instance
 * - clearing of the structure
 * - adding of an PSP item to the structure
 */
 
#include "psx.h"

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/
/** create instance of procedure specification structure
 * @param pointer to procedure specification structure
 */
 
BOOL psp_create (PSX_PSP ** psp)
{
 if (psp == NULL)
  return (FALSE);

 if ((*psp = (PSX_PSP *) malloc (sizeof (**psp))) == NULL)
  return (FALSE);

 memset (*psp,0,sizeof (**psp));

 return (TRUE);
}

/******************************************************************************/
/** delete instance of procedure specification structure
 * @param psp pointer to psp structure
 */

BOOL psp_delete (PSX_PSP ** psp)
{
 if (psp == NULL)
  return (FALSE);

 if (*psp == NULL)
  return (FALSE);

 psp_clr (*psp);

 free (*psp);
 *psp = NULL;

 return (TRUE);
}

/******************************************************************************/
/** clear psp instance
 * @param psp procedure specification structure
 */

BOOL psp_clr (PSX_PSP * psp)
{
 if (psp == NULL)
  return (FALSE);

 if (psp -> itm)
 {
  free (psp -> itm);
  psp -> itm = NULL;
 }

 psp -> n = 0;

 return (TRUE);
}

/******************************************************************************/
/** add an item to procedure spefication instance
 * @param psp target procedure spefication structure
 * @param itm source procedure spefication item
 */

BOOL psp_add (PSX_PSP * psp,PSP_ITM * itm)
{
 PSP_ITM * t;
 int i;

 if (psp == NULL || itm == NULL)
  return (FALSE);

 i = psp -> n;

 if ((t = (PSP_ITM *) realloc (psp -> itm,(i + 1) * sizeof (PSP_ITM))) == NULL)
  return (FALSE);

 psp -> itm = t;
 psp -> itm [i] = *itm;
 psp -> n++;

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


