/******************************************************************************/
/* psx-psp.h                                          Procedure Specification */
/******************************************************************************/
/** @file @psx-psp.h Procedure Specification - Header File
 * Definitions supporting the concept of a procedure specification:
 * - Matchmode Codewords (KSXO)
 * - Status Destination Codewords
 * - PSP Target Structure (PSP_TGT)
 * - PSP Item (PSP_ITM)
 * - PSP Structure (PSX_PSP)
 * - Item Identification Codewords
 * - Prototypes
 */
 
#ifndef _psx_psp_
#define _psx_psp_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Definition                                                                 */
/******************************************************************************/

/**************************************/
/* Match Mode                         */
/**************************************/

typedef BYTE MTM;

#define	MTM_ZERO	0x00

#define	MTM_S0		0x01
#define	MTM_S1		0x02
#define	MTM_SX		(MTM_S0 + MTM_S1)

#define	MTM_K0		0x00
#define	MTM_K1		0x04
//#define	MTM_KX		(MTM_K0 + MTM_K1)

#define	MTM_XI		0x00
#define	MTM_X0		0x08
#define	MTM_X1		0x10

#define	MTM_O0		0x00
#define	MTM_O1		0x20


/**************************************/
/* Status Destination Type            */
/**************************************/

typedef BYTE SDT;

#define	SDT_ZERO	0x00
#define	SDT_STS		0x01
#define	SDT_RSL		0x02

/** PSP Target */
typedef struct _PSP_TGT
{
 SDT sdt;               /**< status destination type                  */
 IDX idx;               /**< index                                    */
 PSX_STR sym;           /**< not always valid, resolved at parse time */
} PSP_TGT;

/** PSP Item.
 * Represents a state in the matching procedure.*/
typedef struct _PSP_ITM
{
 PSX_STR	sym;

 struct
 {
  /** Status type.
   * Value is one of STT_ZERO, STT_QUERY, STT_INPUT
   */
  BYTE stt;            
  /** Matchmode.
   * Encodes the match mode (KSXO Notation) as a bitstring. The constants
   * MTM_S0, MTM_S1, MTM_SX, MTM_K0, MTM_K1, MTM_KX, MTM_XI, MTM_X0, 
   * MTM_X1, MTM_O0, MTM_O1 specify the meaning of individual bits.
   * Field is used only if stt = STT_QUERY.
   */
  MTM  mtm;	             
 //  SPS sps;
 } pro;

 struct
 {
  PSP_TGT tgt_0,tgt_1,tgt_m;
 } epi;
} PSP_ITM;

/** PSP Structure */
typedef struct _PSX_PSP
{
 PSP_ITM * itm;
 NUM       n;
} PSX_PSP;

/**************************************/
/* Item Identification                */
/**************************************/

#define	PSP_ITM_STT	0x01
#define	PSP_ITM_MTM	0x02
#define	PSP_ITM_TGT_0	0x03
#define	PSP_ITM_TGT_1	0x04
#define	PSP_ITM_TGT_M	0x05
#define	PSP_ITM_N	0x05

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE BOOL	psp_create	(PSX_PSP ** psp);
LINKAGE BOOL	psp_delete	(PSX_PSP ** psp);
LINKAGE BOOL	psp_clr		(PSX_PSP * psp);
LINKAGE BOOL	psp_add		(PSX_PSP * psp,PSP_ITM * itm);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_psp_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


