/******************************************************************************/
/* psx-rec.h                            Record Management Interface           */
/******************************************************************************/
/** @file psx-rec.h Record Management Interface - Header File
 * Definitions supporting the Record Management:
 * - Record Item (PSX_REC_ITM)
 * - Record (PSX_REC)
 * - Record Label Definition(PSX_REC_DEF)
 * - Prototypes
 */
 
#ifndef _psx_rec_
#define _psx_rec_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

/** record item                                       */
typedef struct _PSX_REC_ITM  
{
 PSX_STR atr;                /**< attribute           */
 BYTE  val [SYS_STR_MAX];    /**< value               */
} PSX_REC_ITM;

/** record                                            */
typedef struct _PSX_REC     
{
 PSX_REC_ITM * itm;     /**< record item              */
 int     n;             /**< number of record item    */ 
} PSX_REC;

/** record definition label                           */
typedef struct _PSX_REC_DEF
{
 char * lbl;
} PSX_REC_DEF;

#define PSX_REC_DEFINITION(d) PSX_REC_DEF d [] =

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	rec_create	(PSX_REC ** rec);
LINKAGE	BOOL	rec_delete	(PSX_REC ** rec);
LINKAGE	BOOL	rec_clear	(PSX_REC * rec);
LINKAGE	BOOL	rec_define	(PSX_REC * rec,PSX_REC_DEF * def);
LINKAGE	BOOL	rec_def_fmt	(PSX_REC * rec,PSX_FSP * fmt);
LINKAGE	BOOL	rec_map_fmt	(PSX_REC * rec,PSX_FSP * fmt);
LINKAGE	BOOL	rec_fetch	(PSX_REC * rec,PSX_FSP * fmt,PSX_DIC * dic,const char * pfx);
LINKAGE	BOOL	rec_add1	(PSX_REC * rec,const char * atr,const char * val); //BYTE * src,char * lbl);
LINKAGE	BOOL	rec_set		(PSX_REC * rec,int idx,BYTE * src);
LINKAGE	BOOL	rec_putf	(PSX_REC * rec,const char * atr,const char * fmt,...);
LINKAGE	BOOL	rec_get		(PSX_REC * rec,char * atr,char ** val);
LINKAGE	BOOL	rec_get_idx	(PSX_REC * rec,const char * atr,IDX * idx);
LINKAGE	BOOL	rec_copy	(PSX_REC * rec,PSX_REC * src);
LINKAGE	BOOL	rec_fmt_cpy	(PSX_REC * rec,PSX_FSP * fmt);
LINKAGE	BOOL	rec_getLblMax	(PSX_REC * rec,int * n);
LINKAGE	BOOL	rec_getLblStr	(PSX_REC * rec,int idx,PSX_STR s);
LINKAGE	BOOL	rec_gen_rnd	(PSX_REC * rec,PSX_FSP * fsp);

LINKAGE	BOOL	rec_read	(PSX_REC * rec,PSX_FSP * fmt,FILE * f, PSX_STR rst,PSX_STR del);
LINKAGE	BOOL	rec_write	(PSX_REC * rec,PSX_FSP * fsp,FILE * f);
LINKAGE	BOOL	rec_write_m	(PSX_FSP * fsp,FILE * f);
LINKAGE	BOOL	rec_read_s	(PSX_REC * rec,PSX_FSP * fsp,FILE * f);
LINKAGE	BOOL	rec_load	(PSX_REC * rec,PSX_FSP * fsp,char * src);
LINKAGE	BOOL	rec_input	(PSX_REC * rec,int idn);
LINKAGE	BOOL	rec_print	(PSX_REC * rec);

LINKAGE BOOL  rec_cvt_din (PSX_REC * rec);

/******************************************************************************/
/* Macro                                                                      */
/******************************************************************************/

#define REC_ITERATE(_r,_i,_f) for (_i = 0;_i < (_r) -> n;_i++) if ((_f = (_r) -> itm [_i].val) != NULL)

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_rec_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/



