/******************************************************************************/
/* psx-req.c                               Pseudonymization Request Interface */
/******************************************************************************/
/** @file psx-req.c Pseudonymization Request Interface - Source Code File
 * Functions supporting the request process by providing functions for creation
 * and deletion of the request structure.
 */
 
#include "psx.h"

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/
/** create request structure
 * @param req pointer to pointer to request structure
 */
 
BOOL req_create (REQ ** req)
{
 if (req == NULL)
  return (FALSE);

 if ((*req = malloc (sizeof (REQ))) == NULL)
  return (FALSE);

 (*req) -> itm = NULL;
 (*req) -> n   = 0;

 return (TRUE);
}

/******************************************************************************/
/** delete request structure
 * @param req pointer to request structure to be deleted
 */
 
BOOL req_delete (REQ * req)
{
 if (req == NULL)
  return (FALSE);

 if (req -> n > 0)
 {
  int i;

  assert (req -> itm != NULL);

  for (i = 0;i < req -> n;i++)
  {
   assert (req -> itm [i] != NULL);

   free (req -> itm [i]);
  }
 }

 if (req -> itm)
 {
  free (req -> itm);
  req -> itm = NULL;
 }

 free (req);

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


