/******************************************************************************/
/* psx-rgs.h                                 Registry Management Interface    */
/******************************************************************************/
/** @file psx-rgs.h Registry Management Interface - Header File
 * Definitions supporting the Registry Management, this file provides the following
 * datatypes:
 * - Registr Attribute (RGS_ATR)
 * - Registry Value (RGS_VAL)
 * - Registry Management Structure (PSX_RGS)
 * The Prototypes within this file provide the usage of the interface for every
 * other module.
 */
 
#ifndef _psx_rgs_
#define _psx_rgs_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Structure                                                                  */
/******************************************************************************/

/** registry interface attribute structure                                    */
SYS_STRUCTURE (RGS_ATR)
{
 IDX  par;                         /**< parameter number */
 char sym [SYS_STR_MAX];           /**< parameter name   */
};

/**************************************/
/** registry interface value structure                                        */
SYS_STRUCTURE (RGS_VAL)
{
 IDX  idx;                         /**< index of value   */
 char dat [SYS_STR_MAX];           /**< value data       */
};

/**************************************/
/** registry management structure                        */
SYS_STRUCTURE (PSX_RGS)
{
 struct                /**< attribute structure          */
 {
  RGS_ATR * p;         /**< pointer to attribute         */
  NUM       n;
 } atr;

 struct                /**< value structure              */
 {
  RGS_VAL * p;         /**< pointer to value data        */
  NUM       n;
 } val;
};

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

LINKAGE	BOOL	rgs_create	(PSX_RGS ** rgs);
LINKAGE	BOOL	rgs_delete	(PSX_RGS ** rgs);

LINKAGE	BOOL	rgs_put		(PSX_RGS * rgs,const char * atr,char * val);
LINKAGE	BOOL	rgs_get		(PSX_RGS * rgs,const char * atr,char * val);

LINKAGE	BOOL	rgs_read	(PSX_RGS * rgs,FILE * stm);
LINKAGE	BOOL	rgs_write	(PSX_RGS * rgs,FILE * stm);
LINKAGE	BOOL	rgs_load	(PSX_RGS * rgs,char * f);
LINKAGE	BOOL	rgs_save	(PSX_RGS * rgs,char * f);

LINKAGE	BOOL	rgs_dmp		(PSX_RGS * rgs);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_rgs_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


