/******************************************************************************/
/* psx-rsp.c                           Result Specification                   */
/******************************************************************************/
/** @file psx-rsp.c Result Specification - Source Code File
 * Functions implementing the handling of the result specification providing
 * the following functionalities:
 * - creation of a new RSP structure
 * - deletion of an old RSP structure
 * - clearing of an RSP Item
 * - adding a new RSP Item
 */
 
#include "psx.h"

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/

/******************************************************************************/
/** create rsp structure
 * @param rsp pointer to result specification structure
 */

BOOL rsp_create (PSX_RSP ** rsp)
{
 if (rsp == NULL)
  return (FALSE);

 if ((*rsp = (PSX_RSP *) malloc (sizeof (**rsp))) == NULL)
  return (FALSE);

 memset (*rsp,0,sizeof (**rsp));

 return (TRUE);
}

/******************************************************************************/
/** delete rsp Instance
 * @param rsp pointer to result specification structure
 */                                                      

BOOL rsp_delete (PSX_RSP ** rsp)
{
 if (rsp == NULL)
  return (FALSE);

 if (*rsp == NULL)
  return (FALSE);

 rsp_clr (*rsp);

 free (*rsp);
 *rsp = NULL;

 return (TRUE);
}

/******************************************************************************/
/** clear rsp Item
 * @param rsp result specification structure
 */

BOOL rsp_clr (PSX_RSP * rsp)
{
 if (rsp == NULL)
  return (FALSE);

 if (rsp -> itm)
 {
  free (rsp -> itm);
  rsp -> itm = NULL;
 }

 rsp -> n = 0;

 return (TRUE);
}

/******************************************************************************/
/** add rsp Item
 * @param rsp target result specification structure
 * @param itm source result specification item
 */

BOOL rsp_add (PSX_RSP * rsp,RSP_ITM * itm)
{
 RSP_ITM * t;
 int i;

 if (rsp == NULL || itm == NULL)
  return (FALSE);

 i = rsp -> n;

 if ((t = (RSP_ITM *) realloc (rsp -> itm,(i + 1) * sizeof (RSP_ITM))) == NULL)
  return (FALSE);

 rsp -> itm = t;
 rsp -> itm [i] = *itm;
 rsp -> n++;

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


