/******************************************************************************/
/* psx-rsp.h                                             Result Specification */
/******************************************************************************/
/** @file psx-rsp.h Result Specification - Header File
 * Definitions supporting the Result Specification Management.
 * - Definition of Result Retrieval Mode Codewords (PRM)
 * - Record Update Mode Codewords
 * - Datatype definition of the Result Specification Item (RSP_ITM)
 * - Datatype definition of the Result Specification structure (PSX_RSP)
 * - Item Identification Codewords
 */
 
#ifndef _psx_rsp_
#define _psx_rsp_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Definition                                                                 */
/******************************************************************************/

/**************************************/
/** PID Retrieval Mode                */
/**************************************/

typedef BYTE PRM;

#define PRM_ZERO 0x00      /**< pid retrieval mode */
#define PRM_GET  0x01      /**< get pid            */
#define PRM_GEN  0x02      /**< generate new pid   */

/**************************************/
/** Record Update Mode                */
/**************************************/

typedef BYTE RUM;

#define	RUM_ZERO	0x00    
//#define	RUM_RNW		0x01	/* renew    */
//#define	RUM_CPL		0x02	/* complete */
#define	RUM_UPDATE	0x01

/** result specification structure item
 */
typedef struct _RSP_ITM
{
 PSX_STR        sym;      /**< Symbol             */
 PRM            prm;      /**< PID retrieval mode */
 RUM            rum;      /**< record update mode */
 PSX_STR        msg;      /**< message            */
 PSX_STR        not;	  /**< notification		  */
} RSP_ITM;


/** result specification structure
 */
typedef struct _PSX_RSP
{
 /** Result items.
  * Array of size n
  */
 RSP_ITM * itm;
 NUM       n; /**< Number of results. */
} PSX_RSP;

/**************************************/
/* Item Identification                */
/**************************************/

#define RSP_ITM_SYM 0x00
#define RSP_ITM_PRM 0x01
#define RSP_ITM_RUM 0x02
#define RSP_ITM_MSG 0x03
#define RSP_ITM_NOT 0x04
#define RSP_ITM_N   0x05


/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE BOOL	rsp_create	(PSX_RSP ** rsp);
LINKAGE BOOL	rsp_delete	(PSX_RSP ** rsp);
LINKAGE BOOL	rsp_clr		(PSX_RSP * rsp);
LINKAGE BOOL	rsp_add		(PSX_RSP * rsp,RSP_ITM * itm);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_rsp_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


