/******************************************************************************/
/* psx-sch.h                                                           Schema */
/******************************************************************************/
/** @file psx-sch.h Schema Interface - Header File
 * Definitions supporting the usage of a schema for database.
 * - Schema Testtype Codeword definition
 * - Prologue Specification
 * - Schema Field definition (PSX_SCH_FLD)
 * - Schema structure (PSX_SCH)
 * - prototypes
 */
 

#ifndef _psx_sch_
#define _psx_sch_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"


/******************/
/* Test Type      */

#define	STT_ZERO	0x00
#define	STT_QUERY	0x01
#define	STT_INPUT	0x02		// currently input test only

/******************/
/* Prologue Spec  */

typedef BYTE STT;

/******************************************************************************/
/*    schema field                                                            */
/******************************************************************************/

typedef struct _PSX_SCH_FLD
{
 IDX      idx;		/**< Index                                      */
 PSX_STR	sym;		/**< Symbol                                     */
 DTP      dtp;		/**< Datatype                                   */
 PSX_STR	lbl;		/**< Label                                      */
 IDX		  pos;		/**< Position                                   */
 NUM		  len;		/**< Length                                     */
 int		  min;		/**< Minimum                                    */
 int		  max;		/**< Maximum                                    */
 TFM		  tfm;		/**< Transformation Code                        */
 CPS		  cps;		/**< Component Set                              */
 EQU		  equ;		/**< Equality Code                              */
} PSX_SCH_FLD;

/**************************************/
/** Schema specification.
 * Holds data format and matching procedure.
 */
typedef struct _PSX_SCH
{
 PSX_FSP * fsp;   /**< Format specification     */

 PSX_RSP * rsp;    /**< Result specification     */

 PSX_PSP * psp;     /**< Procedure specification  */

} PSX_SCH;


/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	sch_create	(PSX_SCH ** sch);
LINKAGE	BOOL	sch_delete	(PSX_SCH ** sch);

/**************************************/

LINKAGE	BOOL	sch_clear	(PSX_SCH * sch);
LINKAGE	BOOL	sch_assign_fsp	(PSX_SCH * sch,PSX_FMT * fsp);

/**************************************/

LINKAGE	BOOL	sch_fsp_add	(PSX_SCH * sch,FSP_ITM * itm);
LINKAGE	BOOL	sch_rsp_add	(PSX_SCH * sch,RSP_ITM * itm);
LINKAGE	BOOL	sch_psp_add	(PSX_SCH * sch,PSP_ITM * itm);

/**************************************/


LINKAGE	BOOL	sch_atr_sym_get	(PSX_SCH * sch,IDX idx,CMP cmp,PSX_STR sym);
LINKAGE	BOOL	sch_lookup	(PSX_SCH * sch,IDX idx,CMP cmp,PSX_REC * rec,PSX_STR val);

LINKAGE	BOOL	sch_itm_get_stl	(PSX_SCH * sch,IDX idx,PSX_STL * stl);
LINKAGE	BOOL	sch_sym_get_stl	(PSX_SCH * sch,PSX_STL * stl);

LINKAGE	BOOL	sch_sql_get_av	(PSX_SCH * sch,PSX_REC * rec,PSX_STR atr,PSX_STR val);

LINKAGE	BOOL	sch_get_fld	(PSX_SCH * sch,PSX_STR fld);

LINKAGE	BOOL	sch_rec_dummy	(PSX_SCH * sch,PSX_REC * rec);

LINKAGE	BOOL	sch_parse	(PSX_SCH * sch,PSX_STR f);

//LINKAGE	BOOL	sch_load_f	(PSX_SCH * sch,PSX_STR f);

LINKAGE	BOOL	sch_load	(PSX_SCH * sch,DBI * dbi,IDX idx);
LINKAGE	BOOL	sch_save	(PSX_SCH * sch,DBI * dbi,IDX * idx);
LINKAGE	BOOL	sch_print	(PSX_SCH * sch);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_sch_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


