/******************************************************************************/
/* psx-sci.h                                   Standard Commandline Interface */
/******************************************************************************/
/** @file psx-sci.h Standard Commandline Interface - Header File
 * Definitions supporting the commandline option management.
 */
 
#ifndef _psx_sci_
#define _psx_sci_

/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Definition                                                                 */
/******************************************************************************/

#define OPT_ZERO 0x00
#define OPT_BOOL 0x01
#define OPT_INT  0x02
#define OPT_NUM  0x03
#define OPT_STR  0x04

typedef int OTP;

/******************************************************************************/
/* Structure                                                                  */
/******************************************************************************/

typedef int (* SCI_PRC) (void);

/**************************************/

SYS_STRUCTURE (SCI_INT_OPT_OLD)   // old option
{
 char * sym;
 TYPE   otp;
 PTR	ptr;
};

SYS_STRUCTURE (SCI_INT_OPT)       // new option
{
 char * sym;
// PTR	ptr;
 char * syn;
};

/**************************************/

#define SCI_OPT(d) SCI_INT_OPT d [] =

/**************************************/

SYS_STRUCTURE (SCI_INT)            // typedef struct SCI INT
{
 const char *        sym;                //!< name of command
 PTR           ptr;                //!< pointer to procedure
 SCI_INT_OPT * opt;                //!< option (not used ?)
 const char *        syn;                //!< syntax (command line options)
};                                 //

/**************************************/

#define SCI_COMMAND(c) int c (void)
#define SCI_INTERFACE(i) SCI_INT i [] =

/**************************************/

#define SCI_OPT_GET(spc,tgt,def,msg,ret)	\
if (!sci_opt_get ((spc),(tgt),(def)))		\
 if (str_isnil (def))				\
 {						\
  psx_put ("%s",(msg));				\
  return (ret);					\
 }

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

/**************************************/
/* Configuration                      */
/**************************************/

LINKAGE	BOOL	sci_cfg		(SYS_ARG * a);

/**************************************/
/* Parameter Management               */
/**************************************/

LINKAGE	BOOL	sci_par_get	(IDX idx,char * s);
LINKAGE	BOOL	sci_par_peek 	(char * s);
LINKAGE	BOOL	sci_par_fetch	(char * s);
LINKAGE	BOOL	sci_par_back 	(void);
LINKAGE	int	sci_par_count	(void);

/**************************************/
/* Options Management                 */
/**************************************/

LINKAGE	BOOL	sci_opt_fetch	(char * s,char * v);
LINKAGE	BOOL	sci_opt_switch	(char * sym);
LINKAGE	BOOL	sci_opt_get	(const char * fmt,PTR ptr,const char * def);
LINKAGE	BOOL	sci_opt_peek	(SCI_INT_OPT * o,char * sym,PTR p);

/**************************************/
/* Control Management                 */
/**************************************/

LINKAGE	BOOL	sci_prc		(SCI_INT * itf,int * r);
LINKAGE	BOOL	sci_hlp_put	(SCI_INT * itf);

LINKAGE	SCI_COMMAND (sci_hlp);

/**************************************/
/* Input Management                   */
/**************************************/

LINKAGE	BOOL	sci_input	(char * lbl,char * d);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_sci_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/




